#$Id: about.py 285 2016-12-31 19:02:38Z sarkiss $
"""This module is used to create Help --> About... dialog
"""
import wx, os
from wx.lib.wordwrap import wordwrap
version = "0.9.5" #Also used in PyRxDIST/setup.py and http://sourceforge.net/p/pyrx/tickets/
from misc import rcFolder, appName
def About(event):
    "This function is similar to the one used in wx-demo.py (version 2.8.11)."
    info = wx.AboutDialogInfo()
    info.Name = appName+" - Python Prescription"
    updateFolder = os.path.join(rcFolder, 'update')
    if os.path.exists(updateFolder):
        import datetime
        update_time = datetime.datetime.fromtimestamp(os.path.getctime(updateFolder))
        update_time = update_time.strftime("%B %d %Y")
        global version
        version = version +"\nUpdated on: " + str(update_time)
    info.Version = version
    info.Developers =["Sargis Dallakyan"]
    info.WebSite = ("http://pyrx.sourceforge.net/", "PyRx Home Page")
    info.Copyright = "(C)  [2008-Forever], Sargis Dallakyan and individual contributors."
    txt_description = """PyRx is a Virtual Screening software for Computational Drug Discovery that can be used to screen libraries of compounds against potential drug targets.   PyRx enables Medicinal Chemists to run Virtual Screening form any platform  and helps users in every step of this process - from data preparation to job  submission and analysis of the results. 
    
        Thank you and Happy Screening!"""
    info.Description =  wordwrap(txt_description,
      370, wx.ClientDC(wx.GetApp().GetTopWindow()))
#    info.License ="""Copyright (c) [2008-Forever], Sargis Dallakyan and individual contributors. 
#All rights reserved.
#
#Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
#
#    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
#    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
#INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
#DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
#SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
#SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
#WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
#OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."""

    wx.AboutBox(info)
