#$Id: boxUI.py 254 2015-10-04 20:45:05Z sarkiss $

""" boxUI.py contains modified version of tvtk.BoxWidget.
"""
from enthought.traits.api import HasTraits, Range, Float, Button, Tuple, Str, Int, Bool
from enthought.traits.ui.api import View, Item, Group, RangeEditor, spring
from enthought.tvtk.api import tvtk

class AutoGirdBoxUI(tvtk.BoxWidget):
    update_widget = Bool(True) #this variable is used in _anytrait_changed below. Otherwise ChangeBox was not updating properly    
    max_XDimension = Int(126)
    max_YDimension = Int(126)
    max_ZDimension = Int(126)
    maxRange = 126
    initSpacing = Float(0.375)
    X_dimension = Int(50)#Range(0, maxRange, value=initDimension, mode='slider')
    Y_dimension = Int(50)#Range(0, maxRange, value=initDimension, mode='slider')
    Z_dimension = Int(50)#Range(0, maxRange, value=initDimension, mode='slider')
    spacing = Float(0.375)
    X_center = Float()
    Y_center = Float()
    Z_center = Float()
    initCenter = Tuple(X_center,Y_center,Z_center)
    initDimension = Tuple(X_dimension,Y_dimension,Z_dimension)
    reset = Button('Reset')
    #maximize = Button('Maximize')
    
    def _reset_fired(self):
        self.spacing = self.initSpacing
        self.X_dimension, self.Y_dimension, self.Z_dimension = self.initDimension
        self.SetCenter(self.initCenter)
        self.interactor.render()

    def _maximize_fired(self):
        self.spacing = self.initSpacing
        self.X_dimension = self.max_XDimension
        self.Y_dimension = self.max_YDimension
        self.Z_dimension = self.max_ZDimension
        self.SetCenter(self.initCenter)
        self.interactor.render()
         
    def View(self):
        return View( Group( Group( Item('X_center', label='Grid Center  X', format_str="%2.3f", resizable=False),
                                   Item('Y_center', label='Y', format_str="%2.3f", resizable=False),
                                   Item('Z_center', label='Z', format_str="%2.3f", resizable=False),                           
                                    orientation='horizontal'), 
                            
                           Group(Item('X_dimension', label='Number of Points  X', resizable=False),
                                 Item('Y_dimension', label=' Y', resizable=False),
                                 Item('Z_dimension', label=' Z', resizable=False),
                                  orientation='horizontal'),
                                  
                        Group(
                              Item('spacing', label="""Spacing (Angstrom)""",  format_str="%2.3f"),
                              Item('reset', show_label=False), orientation='horizontal'), label="AutoGrid Dimensions", show_border=True)
                                  )
        
    def SetCenter(self, initCenter):
        X, Y, Z  = initCenter
        boundx = X + self.X_dimension*self.spacing/2.
        bound_x = X - self.X_dimension*self.spacing/2.
        boundy = Y + self.Y_dimension*self.spacing/2.
        bound_y = Y - self.Y_dimension*self.spacing/2.
        boundz = Z + self.Z_dimension*self.spacing/2.
        bound_z = Z - self.Z_dimension*self.spacing/2.
        self.place_widget(bound_x,boundx,bound_y,boundy,bound_z,boundz)
        self.X_center = X; self.Y_center = Y; self.Z_center = Z

    def ChangeBox(self, object, event):
        polyData = tvtk.PolyData()
        object.GetPolyData(polyData._vtk_obj)
        self.update_widget = False        
        self.X_center, self.Y_center,self.Z_center = polyData.points[-1]
        
        distZ = abs(polyData.points[-2][2]-polyData.points[-3][2])
        self.Z_dimension = int(round(distZ/self.spacing))
        
        distY = abs(polyData.points[-4][1]-polyData.points[-5][1])
        self.Y_dimension = int(round(distY/self.spacing))
        
        distX = abs(polyData.points[-6][0]-polyData.points[-7][0])
        self.X_dimension = int(round(distX/self.spacing))
        self.update_widget = True
        
    def _anytrait_changed(self):
        if self.update_widget:
            boundx = self.X_center + self.X_dimension*self.spacing/2.
            bound_x = self.X_center - self.X_dimension*self.spacing/2.
            boundy = self.Y_center + self.Y_dimension*self.spacing/2.
            bound_y = self.Y_center - self.Y_dimension*self.spacing/2.
            boundz = self.Z_center + self.Z_dimension*self.spacing/2.
            bound_z = self.Z_center - self.Z_dimension*self.spacing/2.
            if self.interactor:
                self.place_widget(bound_x,boundx,bound_y,boundy,bound_z,boundz)
                self.interactor.render()
                
class VinaBoxUI(tvtk.BoxWidget):
    update_widget = Bool(True) #this variable is used in _anytrait_changed below. Otherwise ChangeBox was not updating properly
    max_XDimension = Float(126)
    max_YDimension = Float(126)
    max_ZDimension = Float(126)    
    X_dimension = Float(25)#Range(0, maxRange, value=initDimension, mode='slider')
    Y_dimension = Float(25)#Range(0, maxRange, value=initDimension, mode='slider')
    Z_dimension = Float(25)#Range(0, maxRange, value=initDimension, mode='slider')
    X_center = Float()
    Y_center = Float()
    Z_center = Float()
    initCenter = Tuple(X_center,Y_center,Z_center)
    initDimension = Tuple(X_dimension,Y_dimension,Z_dimension)
    reset = Button('Reset')
    #maximize = Button('Maximize')
    
    def _reset_fired(self):
        self.X_dimension, self.Y_dimension, self.Z_dimension = self.initDimension
        self.SetCenter(self.initCenter)
        self.interactor.render()

    def _maximize_fired(self):
        self.X_dimension = self.max_XDimension
        self.Y_dimension = self.max_YDimension
        self.Z_dimension = self.max_ZDimension
        self.SetCenter(self.initCenter)
        self.interactor.render()
         
    def View(self):
        return View( Group( Group( Item('X_center', label='Center  X', format_str="%2.3f", resizable=False),
                                   Item('Y_center', label='Y', format_str="%2.3f", resizable=False),
                                   Item('Z_center', label='Z', format_str="%2.3f", resizable=False),                           
                                    orientation='horizontal'),         
                            Group(Item('X_dimension',  label="Dimensions (Angstrom) X", format_str="%2.3f",resizable=False),
                                 Item('Y_dimension',  label=' Y', format_str="%2.3f", resizable=False),
                                 Item('Z_dimension',  label=' Z', format_str="%2.3f", resizable=False),
                                  orientation='horizontal'),
                        Group(Item('reset', show_label=False), orientation='horizontal'), 
                    label="Vina Search Space", show_border=True)
                    )
    
    def _anytrait_changed(self):
        if self.update_widget:
            boundx = self.X_center + self.X_dimension/2.
            bound_x = self.X_center - self.X_dimension/2.
            boundy = self.Y_center + self.Y_dimension/2.
            bound_y = self.Y_center - self.Y_dimension/2.
            boundz = self.Z_center + self.Z_dimension/2.
            bound_z = self.Z_center - self.Z_dimension/2.       
            if self.interactor:
                self.place_widget(bound_x,boundx,bound_y,boundy,bound_z,boundz)
                self.interactor.render()
        
    def SetCenter(self, initCenter):
        X, Y, Z  = initCenter
        boundx = X + self.X_dimension/2.
        bound_x = X - self.X_dimension/2.
        boundy = Y + self.Y_dimension/2.
        bound_y = Y - self.Y_dimension/2.
        boundz = Z + self.Z_dimension/2.
        bound_z = Z - self.Z_dimension/2.
        self.place_widget(bound_x,boundx,bound_y,boundy,bound_z,boundz)
        self.X_center = X; self.Y_center = Y; self.Z_center = Z

    def ChangeBox(self, object, event):
        polyData = tvtk.PolyData()
        object.GetPolyData(polyData._vtk_obj)
        self.update_widget = False
        self.X_center, self.Y_center,self.Z_center = polyData.points[-1]
        self.Z_dimension = abs(polyData.points[-2][2]-polyData.points[-3][2])
        self.Y_dimension = abs(polyData.points[-4][1]-polyData.points[-5][1])        
        self.X_dimension = abs(polyData.points[-6][0]-polyData.points[-7][0])
        self.update_widget = True