#$Id: download.py 91 2011-02-07 23:01:27Z sarkiss $
import wx
import urllib
import os
def download(url, dest):
    dlg = wx.ProgressDialog("Download Progress",
                       "Please wait...",
                           style = wx.PD_CAN_ABORT
                            | wx.PD_APP_MODAL
                            | wx.PD_ELAPSED_TIME
                            | wx.PD_ESTIMATED_TIME
                            )
    dlg.Update(0, "Please Wait...") 
    fURL = urllib.urlopen(url)
    header = fURL.info()
    size = None
    max = 100
    outFile = open(dest, 'wb')
    keepGoing = True
    if "content-length" in header:
        size = int(header["Content-Length"])
        kBytes = size/1024
        downloadBytes = size/max
        count = 0    
        while keepGoing:
            count += 1
            if count >= max:
                count  = 99
            (keepGoing, skip) = dlg.Update(count, "Downloaded "+str(count*downloadBytes/1024)+" of "+ str(kBytes)+"KB")    
            b = fURL.read(downloadBytes)
            if b:
                outFile.write(b)
            else:
                break
    else:
            while keepGoing:
                (keepGoing, skip) = dlg.UpdatePulse()
                b = fURL.read(1024*8)
                if b:
                    outFile.write(b)
                else:
                    break
    outFile.close()
    
    dlg.Update(99, "Downloaded "+ str(os.path.getsize(dest)/1024)+"KB")       
    dlg.Destroy()
    return  keepGoing

if __name__ == "__main__":
    app = wx.App()
    download('http://voxel.dl.sourceforge.net/sourceforge/wxpython/wxPython-docs-2.8.9.2.tar.bz2'
             , 'wxPython-docs-2.8.9.2.tar.bz2')