#$Id: logger.py 242 2015-01-02 00:00:44Z sarkiss $
from enthought.logger.plugin.logger_service import LoggerService
from enthought.traits.api import HasTraits
from enthought.logger import logger
import logging
from enthought.preferences.api import get_default_preferences
import sys, traceback, os
#logging.basicConfig(level="CRITICAL")
logging.raiseExceptions = 0

from enthought.logger.plugin.view.logger_preferences_page import LoggerPreferencesPage
from enthought.preferences.ui.api import PreferencesPage
from enthought.traits.api import Bool, Trait, Str
from enthought.traits.ui.api import EnumEditor, Group, Item, View

class MyLoggerPreferencesPage(PreferencesPage):
    """ A preference page for the logger plugin.
    """

    #### 'PreferencesPage' interface ##########################################

    # The page's category (e.g. 'General/Appearance'). The empty string means
    # that this is a top-level page.
    category = ''

    # The page's help identifier (optional). If a help Id *is* provided then
    # there will be a 'Help' button shown on the preference page.
    help_id = ''

    # The page name (this is what is shown in the preferences dialog.
    name = 'Logger'

    # The path to the preferences node that contains the preferences.
    preferences_path = 'Logger'


    #### Preferences ###########################################################

    showLoggerOnUpdate = Bool(True)
    # The log levels
    level = Trait('Info', 
        {'Debug'    : logging.DEBUG,
         'Info'     : logging.INFO,
         'Warning'  : logging.WARNING,
         'Error'    : logging.ERROR,
         'Critical' : logging.CRITICAL,
        },
        is_str = True,
    )

    enable_agent = Bool(False)
    smtp_server = Str
    to_address = Str
    from_address = Str
    

    # The view used to change the plugin preferences
    traits_view = View(
                       Item("showLoggerOnUpdate", 
                                 label=" Pop Logger tab to front when a new  message appears"),
                    
        Group(
            Group(
                Item(
                    name='level',
                    editor=EnumEditor(
                        values={
                            'Debug'    : '1:Debug',
                            'Info'     : '2:Info',
                            'Warning'  : '3:Warning',
                            'Error'    : '4:Error' ,
                            'Critical' : '5:Critical',
                        },
                    ),
                    style='simple',
                ), 
                label='Logger Settings',
                show_border=True,
            ),
            Group(Item(name='10')),
            Group(
                Group(
                    Group(Item(name='enable_agent', label='Enable quality agent'), show_left=False),
                    Group(Item(name='smtp_server', label='SMTP server'),
                          Item(name='from_address'), 
                          Item(name='to_address'), enabled_when='enable_agent==True')),
                label='Quality Agent Settings',
                show_border=True,
            ),
        ),
    )
logger_preferences = MyLoggerPreferencesPage(enable_agent=True,
                                           smtp_server ="localhost",
                                           to_address="dallakyans@gmail.com",
                                           from_address="Please enter you email here.")
from preferences import global_preferences
class Logger:
    def __init__(self, frame):
        formatter = logging.Formatter('%(levelname)s|%(asctime)s|%(message)s')
        #lp = LoggerPlugin()
        #lp.level_ = 0 
        log = logging.getLogger(__name__)
        handler = logger.add_log_queue_handler(log)
        service = LoggerService(preferences=logger_preferences)
        handler.setFormatter(formatter)
        service.handler = handler
        if sys.version_info[0] == 2 and sys.version_info[1] == 5:            
            from enthought.logger.widget import logger_widget            
            self.widget = logger_widget.LoggerWidget(frame, service)
            icon = self.widget._listControl._get_icon('images/about.png')

            self.oldUpdate = self.widget._listControl.update
            self.widget._listControl.update = self.update
        else:
            from enthought.envisage.ui.workbench.api import WorkbenchApplication
            app = WorkbenchApplication(name="PyRx")
            service.application = app
            from enthought.logger.plugin.view import logger_view
            lo = logger_view.LoggerView(service=service)
            v = lo.trait_view().ui(lo, frame,  kind='subpanel')
            self.oldUpdate = lo.update 
            lo.update = self.update
            self.widget = v.control
            from enthought.logger.plugin import view
            import wx
            icon = wx.Bitmap(os.path.join(view.__path__[0],"images", "info.png"))
            self.loggerView = lo
        handler.dirty = True        
        frame.log = log
        self.frame = frame        
        self.frame.controls.AddPage(self.widget, "Logger", bitmap=icon)
        
    def update(self):
        pref = global_preferences
        if pref.get('Logger.showLoggerOnUpdate') == "True":
            self.frame.controls.SetSelection(self.frame.controls.GetPageIndex(self.widget))
        self.oldUpdate()
        
