#$Id: pbsJobs.py 256 2015-11-01 00:25:08Z sarkiss $

import  wx
import time, os, sys, subprocess
import utils
from vsModel import autodockPreferencesPage, autodockRemotePreferencesPage 
def startAutogrid(parent): 
        cwdTxt = parent.vsModel.macromolecule.receptorFolder 
        readme = os.path.join(cwdTxt, "README")
        if (check_jobs(readme)):
            dlg = wx.MessageDialog(parent, "It seems that Autogrid jobs are still running.\nPlease wait for these jobs to finish.",'A Message Box',
                                   wx.OK| wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()         
            return False    
        cmdTxt = ' '.join(parent.vsModel.gridCommand)
        cmdTxt = cmdTxt.replace(autodockPreferencesPage.autogrid, utils.which(autodockPreferencesPage.autogrid))
        rJob = os.path.join(cwdTxt, "PyRxAutoGridJob")
        oFile = open(rJob,'w')
        oFile.write("#$ -S /bin/bash \n") #for SGE
        oFile.write("cd "+cwdTxt+"\n")
        oFile.write(cmdTxt)    
        oFile.close()
        os.system("chmod +x "+ rJob)
        id = subprocess.Popen("qsub " + rJob , shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT).stdout.read()
        oFile = open(readme, 'w')
        oFile.write("Submitted AutoGrid job for "+parent.vsModel.macromolecule.name+" :  qsub  PyRxAutoGridJob\n")
        oFile.write(id)
        oFile.write("Done\n\nPlease wait for this job to finish before starting AutoDock.")
        oFile.write("\n\nRun 'qstat "+id.split('.')[0]+"' from a command line to see the status of this job.")
        oFile.write("\nRun 'qdel "+id.split('.')[0]+"' to delete this job.")
        oFile.close()
        wx.GetApp().GetTopWindow().documentsView.ClosePath(readme)
        wx.GetApp().GetTopWindow().documentsView.OpenDocument(readme)
        return True
    
def startAutodock(parent):
    readme = os.path.join(parent.vsModel.etcFolder, "Cluster_AutoDock_README")
    if (check_jobs(readme)):
        dlg = wx.MessageDialog(parent, "It seems that AutoDock jobs are still running.\nPlease wait for these jobs to finish.",'A Message Box',
                               wx.OK| wx.ICON_EXCLAMATION)
        dlg.ShowModal()
        dlg.Destroy()         
        return False    
    open(readme, 'w')    
    wx.GetApp().GetTopWindow().documentsView.ClosePath(readme) 
    doc = wx.GetApp().GetTopWindow().documentsView.OpenDocument(readme)
    txtCtrl = doc.GetFirstView().GetTextCtrl()
    txtCtrl.AppendText("Creating AutoDock jobs with the following ID's:\n")
    parent.Update()
    lenLigands =  len(parent.ligands)
    lenMacromolecules =  len(parent.frame.autodockWiz.runAutoGrid.macromolecules)
    maximum = lenLigands*lenMacromolecules
    dlg = wx.ProgressDialog("AutoDock Job Submission Progress",
                           "AutoDock Job Submission in Progress. Please Wait...",
                           maximum = maximum,
                           parent = parent,
                           style = wx.PD_CAN_ABORT
                            | wx.PD_APP_MODAL
                            | wx.PD_ELAPSED_TIME
                            | wx.PD_REMAINING_TIME
                            )        
    try:
        for macro_index, macromolecule in enumerate(parent.frame.autodockWiz.runAutoGrid.macromolecules): 
            for index, ligand in enumerate(parent.ligands):
                (keepGoing, skip) = dlg.Update(index+lenLigands*macro_index, "Sending Data for "+ligand+" ("+str(index+1) +" of " +str(lenLigands)+")"\
                                               "\nMacromolecule is "+macromolecule.name+" ("+str(macro_index+1) +" of " +str(lenMacromolecules)+")")            
                if not keepGoing:
                    break
                parent.vsModel.macromolecule = macromolecule
                parent.vsModel.PrepareDPF(parent.vsModel.molDict[ligand], parent.docking_algorithm_parameter_list)  
                rJob = os.path.join(parent.vsModel.dockingFolder, "PyRxAutoDockJob")
                oFile = open(rJob,'w')
                oFile.write("#$ -S /bin/bash \n") #for SGE
                cmdStr = ' '.join(parent.vsModel.dockCommand)
                cmdStr = cmdStr.replace(autodockPreferencesPage.autodock, utils.which(autodockPreferencesPage.autodock))
                oFile.write("cd "+parent.vsModel.dockingFolder+"\n")
                oFile.write(cmdStr)    
                oFile.close()
                os.system("chmod +x "+ rJob)
                id = subprocess.Popen("qsub  " + rJob , shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT).stdout.read()
                txtCtrl.AppendText(id)
                txtCtrl.ScrollToEnd()
                parent.Update()
    except Exception,e:
        parent.frame.log.error("Error in running AutoDock in the cluster: \n"+str(e))                
    dlg.Destroy()        
    txtCtrl.AppendText("Done\n\n\nPlease wait to these jobs to finish to analyze the results.\nRun `qstat` from a command line to show status of batch jobs")
    doc.Save()

def startVina(parent):
    readme = os.path.join(parent.vsModel.etcFolder, "Cluster_Vina_README")
    if (check_jobs(readme)):
        dlg = wx.MessageDialog(parent, "It seems that Vina jobs are still running.\nPlease wait for these jobs to finish.",'A Message Box',
                               wx.OK| wx.ICON_EXCLAMATION)
        dlg.ShowModal()
        dlg.Destroy()         
        return False
    open(readme, 'w')
    wx.GetApp().GetTopWindow().documentsView.ClosePath(readme) 
    doc = wx.GetApp().GetTopWindow().documentsView.OpenDocument(readme)
    txtCtrl = doc.GetFirstView().GetTextCtrl()
    txtCtrl.AppendText("Creating Vina jobs with the following ID's:\n")
    parent.Update()
    lenMacromolecules = len(parent.macromolecules)
    lenLigands = len(parent.ligands)
    maximum =  lenLigands*lenMacromolecules
    dlg = wx.ProgressDialog("Vina Job Submission Progress",
                            "Vina Job Submission in Progress. Please Wait...",
                            maximum = maximum,
                            parent = parent,
                            style = wx.PD_CAN_ABORT | wx.PD_APP_MODAL | wx.PD_ELAPSED_TIME | wx.PD_REMAINING_TIME
                           )
    try:
        for macro_index, macromolecule in enumerate(parent.macromolecules):
            basePath = macromolecule.basePath 
            for index, ligand in enumerate(parent.ligands):
                (keepGoing, skip) = dlg.Update(index+lenLigands*macro_index, "Submitting "+ligand+" ("+str(index+1) +" of " +str(lenLigands)+")"+
                                                       "\nMacromolecule is "+macromolecule.name+" ("+str(macro_index+1) +" of " +str(lenMacromolecules)+")")
                if not keepGoing:
                    break
                ligandFolder = os.pardir+os.sep+os.pardir+os.path.sep+"Ligands"         
                outputFile = ligand+"_out.pdbqt"
                rJob = os.path.join(basePath, "PyRxVinaJob-"+ligand)
                oFile = open(rJob,'w')
                oFile.write("#$ -S /bin/bash \n") #for SGE
                oFile.write("cd "+basePath+"\n")
                vina = utils.which(autodockPreferencesPage.vina)
                cmdStr = vina+ " --config conf.txt --ligand " +ligandFolder+os.path.sep+ligand+".pdbqt" + ' --out '+outputFile
                oFile.write(cmdStr)    
                oFile.close()
                os.system("chmod +x "+ rJob)
                id = subprocess.Popen("qsub " + rJob , shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT).stdout.read()
                txtCtrl.AppendText(id)
                txtCtrl.ScrollToEnd()
                parent.Update()
    except Exception,e:
        parent.frame.log.error("Error in running Vina in the cluster: \n"+str(e))
    dlg.Destroy()        
    txtCtrl.AppendText("Done\n\n\nPlease wait to these jobs to finish to analyze the results.\nRun `qstat` from a command line to show status of batch jobs.")
    doc.Save()
    return True

def check_jobs(readme):
    "Check to see if the jobs are still running. Returns True if the jobs are still running, or False if they are not."
    if os.path.exists(readme):
        lines = open(readme).readlines()
        job_ids = []
        if lines:
            for line in lines[1:]:
                if line =="Done\n" or line=="\n":
                    break
                else:
                    job_ids.append(line.strip())
        for job_id in job_ids:
            txt = subprocess.Popen("qstat " + job_id , shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT).stdout.readlines()
            if len(txt) > 2:
                return True
        os.remove(readme)
        return False 
    else:
        return  False