#$Id: preferences.py 263 2015-12-31 00:15:49Z sarkiss $
"""Preferences.py is used for Edit --> Preferences dialog
"""
import  wx, os
from enthought.preferences.api import Preferences, PreferencesHelper
from enthought.preferences.api import get_default_preferences
from enthought.preferences.api import set_default_preferences
from enthought.preferences.ui.api import PreferencesManager, PreferencesPage
from utils import rcFile, cpuCount, which

try:
    global_preferences = Preferences(filename=rcFile)
except Exception, inst:
    os.remove(rcFile)
    from utils import createPreferences
    createPreferences()
    global_preferences = Preferences(filename=rcFile)

set_default_preferences(global_preferences)
    
from vsModel import autodockPreferencesPage, receptorPreparationPage, ligandPreparationPage, autodockRemotePreferencesPage
from traitedBabel import openbabelParameters, openbabelAutoDockParameters

pages=[
    autodockPreferencesPage,
    receptorPreparationPage,
    ligandPreparationPage,
    autodockRemotePreferencesPage,
    openbabelParameters,
    openbabelAutoDockParameters,
    ]

from logger import logger_preferences
pages.append(logger_preferences)
          
preferences_manager = PreferencesManager(pages=pages)

def setGlobalPreferences():
    set_default_preferences(global_preferences)