#Author: Sargis Dallakyan (sargis@scripps.edu)
#$Header: /opt/cvs/PyRxDIST/tests/template.py,v 1.5 2009/06/19 16:35:51 sargis Exp $
#$Id: template.py 255 2015-10-12 00:52:28Z sarkiss $
"""Contains Test class that is used for other tests """
import unittest
import os, sys
from PyRx.wxMainFrame import MainFrame
import PyRx
import wx, time
stdout = sys.stdout
dataDir = os.path.join(os.path.split(__file__)[0], 'data')
lig= 'his'
ligand = lig+'.pdb'
macro = '1crn'
macromol = macro+'.pdb'
ligPDBQT = ligand+'qt'
#sys.stderr.write(PyRx.__path__[0])
maxCount = 1000000000
class Test(unittest.TestCase):
    def setUp(self):
        self.app = wx.App()
        self.frame = MainFrame(None)
        self.frame.Show()
        sys.stdout = stdout
        self.running = False
        self.ligPath = os.path.join(self.frame.vsModel.ligandsFolder, ligPDBQT)  
        self.macroPath = os.path.join(self.frame.vsModel.macromoleculesFolder, macro)

    def tearDown(self):
        self.frame.Destroy()
        self.frame.Close()
        self.app.ExitMainLoop()   
        wx.WakeUpMainThread()
        wx.GetApp().Exit()
        wx.WakeUpMainThread()
        wx.GetApp().ExitMainLoop()
        del self.frame     
        del self.app

class Event:
    X = 0
    Y = 0
    def GetPosition(self):
        return wx.Point(self.X, self.Y)
    