#$Id: testVinaWizard.py 290 2017-01-14 21:05:09Z sarkiss $
from template import Test
import wx
import unittest, time
maxCount = 100000000
from PyRx.preferences import global_preferences

class TestVinaWizard(Test):
    
    def runVina(self):
        "tests for Vina Wizard"
        self.frame.vinaWiz.startPage.SetActive(None)
        self.frame.vinaWiz.startPage.Start(None)
        self.frame.vinaWiz.analyzePage.dockings = {}
        item = self.frame.autodockNav.autodockTree.ligandTree.treeDict[self.ligPath]
        self.frame.autodockNav.autodockTree.ligandTree.tree.SelectItem(item)
        item = self.frame.autodockNav.autodockTree.macromoleculeTree.treeDict[self.macroPath]
        self.frame.autodockNav.autodockTree.macromoleculeTree.tree.SelectItem(item)
        self.frame.vinaWiz.selectMoleculesPage.SetActive(None)
        self.frame.vinaWiz.selectMoleculesPage.Next(None)
        self.frame.vinaWiz.runVinaPage.SetActive(None)
        self.frame.vinaWiz.runVinaPage.Next(None)
        counter = 1
        while not self.frame.vinaWiz.analyzePage.dockings:
            wx.Yield()
            counter += 1
            if counter > maxCount:
                self.fail("Can't finish runVina after "+str(maxCount)+" tries.")

    def test_local(self):
        global_preferences.set('AutoDock.vinaExecutionMode', 0)
        global_preferences.flush()
        self.runVina()
        self.assertTrue(self.frame.vinaWiz.analyzePage.dockings)

    def test_remote(self):
        global_preferences.set('AutoDock.vinaExecutionMode', 1)
        global_preferences.flush()
        self.runVina()
        self.assertTrue(self.frame.vinaWiz.analyzePage.dockings)

if __name__ == '__main__':
    unittest.main()