##################################################
# file: eUtilsService_types.py
#
# schema types generated by "ZSI.generate.wsdl2python.WriteServiceModule"
#    /usr/local/bin/wsdl2py --lazy -b http://www.ncbi.nlm.nih.gov/entrez/eutils/soap/v2.0/eutils.wsdl
#
##################################################

import ZSI
import ZSI.TCcompound
from ZSI.schema import LocalElementDeclaration, ElementDeclaration, TypeDefinition, GTD, GED
from ZSI.generate.pyclass import pyclass_type

##############################
# targetNamespace
# http://www.ncbi.nlm.nih.gov/soap/eutils/
##############################

class ns0:
    targetNamespace = "http://www.ncbi.nlm.nih.gov/soap/eutils/"

# end class ns0 (tns: http://www.ncbi.nlm.nih.gov/soap/eutils/)

##############################
# targetNamespace
# http://www.ncbi.nlm.nih.gov/soap/eutils/esummary
##############################

class ns2:
    targetNamespace = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"

    class DocSumType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        type = (schema, "DocSumType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns2.DocSumType_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"Id"), aname="_Id", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","ItemType",lazy=True)(pname=(ns,"Item"), aname="_Item", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Id = None
                    self._Item = []
                    return
            Holder.__name__ = "DocSumType_Holder"
            self.pyclass = Holder

    class ItemType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        type = (schema, "ItemType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns2.ItemType_Def.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","ItemType",lazy=True)(pname=(ns,"Item"), aname="_Item", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"ItemContent"), aname="_ItemContent", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            else:
                # attribute handling code
                self.attribute_typecode_dict["Name"] = ZSI.TC.String()
                self.attribute_typecode_dict["Type"] = ZSI.TC.String()
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Item = []
                    self._ItemContent = None
                    return
            Holder.__name__ = "ItemType_Holder"
            self.pyclass = Holder

    class eSummaryResult_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "eSummaryResult"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        def __init__(self, **kw):
            ns = ns2.eSummaryResult_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ERROR"), aname="_ERROR", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","DocSumType",lazy=True)(pname=(ns,"DocSum"), aname="_DocSum", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","eSummaryResult")
            kw["aname"] = "_eSummaryResult"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ERROR = None
                    self._DocSum = []
                    return
            Holder.__name__ = "eSummaryResult_Holder"
            self.pyclass = Holder

    class db_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "db"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","db")
            kw["aname"] = "_db"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_db_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class id_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "id"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","id")
            kw["aname"] = "_id"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_id_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class WebEnv_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "WebEnv"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","WebEnv")
            kw["aname"] = "_WebEnv"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_WebEnv_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class query_key_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "query_key"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","query_key")
            kw["aname"] = "_query_key"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_query_key_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class retstart_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "retstart"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","retstart")
            kw["aname"] = "_retstart"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_retstart_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class retmax_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "retmax"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","retmax")
            kw["aname"] = "_retmax"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_retmax_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class tool_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "tool"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","tool")
            kw["aname"] = "_tool"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_tool_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class email_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "email"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","email")
            kw["aname"] = "_email"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_email_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class eSummaryRequest_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "eSummaryRequest"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esummary"
        def __init__(self, **kw):
            ns = ns2.eSummaryRequest_Dec.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","db",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","id",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","WebEnv",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","query_key",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","retstart",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","retmax",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","tool",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","email",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esummary","eSummaryRequest")
            kw["aname"] = "_eSummaryRequest"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._db = None
                    self._id = None
                    self._WebEnv = None
                    self._query_key = None
                    self._retstart = None
                    self._retmax = None
                    self._tool = None
                    self._email = None
                    return
            Holder.__name__ = "eSummaryRequest_Holder"
            self.pyclass = Holder

# end class ns2 (tns: http://www.ncbi.nlm.nih.gov/soap/eutils/esummary)

##############################
# targetNamespace
# http://www.ncbi.nlm.nih.gov/soap/eutils/elink
##############################

class ns3:
    targetNamespace = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"

    class IdType_Def(ZSI.TC.String, TypeDefinition):
        # ComplexType/SimpleContent derivation of built-in type
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "IdType")
        def __init__(self, pname, **kw):
            if getattr(self, "attribute_typecode_dict", None) is None: self.attribute_typecode_dict = {}
            # attribute handling code
            self.attribute_typecode_dict["HasLinkOut"] = ZSI.TC.String()
            self.attribute_typecode_dict["HasNeighbor"] = ZSI.TC.String()
            ZSI.TC.String.__init__(self, pname, **kw)
            class Holder(str):
                __metaclass__ = pyclass_type
                typecode = self
            self.pyclass = Holder

    class IdCheckListType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "IdCheckListType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns3.IdCheckListType_Def.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IdType",lazy=True)(pname=(ns,"Id"), aname="_Id", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IdLinkSetType",lazy=True)(pname=(ns,"IdLinkSet"), aname="_IdLinkSet", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","ERROR",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Id = []
                    self._IdLinkSet = []
                    self._ERROR = None
                    return
            Holder.__name__ = "IdCheckListType_Holder"
            self.pyclass = Holder

    class IdLinkSetType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "IdLinkSetType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns3.IdLinkSetType_Def.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","LinkInfoType",lazy=True)(pname=(ns,"LinkInfo"), aname="_LinkInfo", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._LinkInfo = []
                    return
            Holder.__name__ = "IdLinkSetType_Holder"
            self.pyclass = Holder

    class IdListType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "IdListType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns3.IdListType_Def.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IdType",lazy=True)(pname=(ns,"Id"), aname="_Id", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Id = []
                    return
            Holder.__name__ = "IdListType_Holder"
            self.pyclass = Holder

    class IdUrlListType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "IdUrlListType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns3.IdUrlListType_Def.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IdUrlSetType",lazy=True)(pname=(ns,"IdUrlSet"), aname="_IdUrlSet", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","ERROR",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._IdUrlSet = []
                    self._ERROR = None
                    return
            Holder.__name__ = "IdUrlListType_Holder"
            self.pyclass = Holder

    class IdUrlSetType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "IdUrlSetType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns3.IdUrlSetType_Def.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IdType",lazy=True)(pname=(ns,"Id"), aname="_Id", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","ObjUrlType",lazy=True)(pname=(ns,"ObjUrl"), aname="_ObjUrl", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Info",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Id = None
                    self._ObjUrl = []
                    self._Info = None
                    return
            Holder.__name__ = "IdUrlSetType_Holder"
            self.pyclass = Holder

    class LinkType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "LinkType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns3.LinkType_Def.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IdType",lazy=True)(pname=(ns,"Id"), aname="_Id", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Score",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Id = None
                    self._Score = None
                    return
            Holder.__name__ = "LinkType_Holder"
            self.pyclass = Holder

    class LinkInfoType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "LinkInfoType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns3.LinkInfoType_Def.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","DbTo",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"LinkName"), aname="_LinkName", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","MenuTag",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._DbTo = None
                    self._LinkName = None
                    self._MenuTag = None
                    return
            Holder.__name__ = "LinkInfoType_Holder"
            self.pyclass = Holder

    class LinkSetType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "LinkSetType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns3.LinkSetType_Def.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","DbFrom",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","ERROR",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IdListType",lazy=True)(pname=(ns,"IdList"), aname="_IdList", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","LinkSetDbType",lazy=True)(pname=(ns,"LinkSetDb"), aname="_LinkSetDb", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IdUrlListType",lazy=True)(pname=(ns,"IdUrlList"), aname="_IdUrlList", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IdCheckListType",lazy=True)(pname=(ns,"IdCheckList"), aname="_IdCheckList", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._DbFrom = None
                    self._ERROR = None
                    self._IdList = None
                    self._LinkSetDb = []
                    self._IdUrlList = None
                    self._IdCheckList = None
                    return
            Holder.__name__ = "LinkSetType_Holder"
            self.pyclass = Holder

    class LinkSetDbType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "LinkSetDbType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns3.LinkSetDbType_Def.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","DbTo",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"LinkName"), aname="_LinkName", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","LinkType",lazy=True)(pname=(ns,"Link"), aname="_Link", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Info",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","ERROR",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._DbTo = None
                    self._LinkName = None
                    self._Link = []
                    self._Info = None
                    self._ERROR = None
                    return
            Holder.__name__ = "LinkSetDbType_Holder"
            self.pyclass = Holder

    class ObjUrlType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "ObjUrlType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns3.ObjUrlType_Def.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Url",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IconUrl",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"LinkName"), aname="_LinkName", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","SubjectType",lazy=True, isref=True)(minOccurs=0, maxOccurs="unbounded", nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Attribute",lazy=True, isref=True)(minOccurs=0, maxOccurs="unbounded", nillable=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","ProviderType",lazy=True)(pname=(ns,"Provider"), aname="_Provider", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Url = None
                    self._IconUrl = None
                    self._LinkName = None
                    self._SubjectType = None
                    self._Attribute = None
                    self._Provider = None
                    return
            Holder.__name__ = "ObjUrlType_Holder"
            self.pyclass = Holder

    class ProviderType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        type = (schema, "ProviderType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns3.ProviderType_Def.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Name",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","NameAbbr",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IdType",lazy=True)(pname=(ns,"Id"), aname="_Id", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Url",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IconUrl",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Name = None
                    self._NameAbbr = None
                    self._Id = None
                    self._Url = None
                    self._IconUrl = None
                    return
            Holder.__name__ = "ProviderType_Holder"
            self.pyclass = Holder

    class Attribute_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Attribute"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Attribute")
            kw["aname"] = "_Attribute"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Attribute_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class DbFrom_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "DbFrom"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","DbFrom")
            kw["aname"] = "_DbFrom"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_DbFrom_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class DbTo_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "DbTo"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","DbTo")
            kw["aname"] = "_DbTo"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_DbTo_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class ERROR_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "ERROR"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","ERROR")
            kw["aname"] = "_ERROR"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_ERROR_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class IconUrl_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "IconUrl"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","IconUrl")
            kw["aname"] = "_IconUrl"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_IconUrl_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class Info_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Info"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Info")
            kw["aname"] = "_Info"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Info_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class Name_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Name"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Name")
            kw["aname"] = "_Name"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Name_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class NameAbbr_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "NameAbbr"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","NameAbbr")
            kw["aname"] = "_NameAbbr"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_NameAbbr_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class Score_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Score"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Score")
            kw["aname"] = "_Score"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Score_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class SubjectType_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "SubjectType"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","SubjectType")
            kw["aname"] = "_SubjectType"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_SubjectType_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class Url_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Url"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","Url")
            kw["aname"] = "_Url"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Url_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class MenuTag_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "MenuTag"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","MenuTag")
            kw["aname"] = "_MenuTag"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_MenuTag_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class eLinkResult_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "eLinkResult"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            ns = ns3.eLinkResult_Dec.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","ERROR",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","LinkSetType",lazy=True)(pname=(ns,"LinkSet"), aname="_LinkSet", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","eLinkResult")
            kw["aname"] = "_eLinkResult"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ERROR = None
                    self._LinkSet = []
                    return
            Holder.__name__ = "eLinkResult_Holder"
            self.pyclass = Holder

    class db_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "db"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","db")
            kw["aname"] = "_db"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_db_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class id_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "id"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","id")
            kw["aname"] = "_id"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_id_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class reldate_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "reldate"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","reldate")
            kw["aname"] = "_reldate"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_reldate_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class mindate_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "mindate"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","mindate")
            kw["aname"] = "_mindate"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_mindate_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class maxdate_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "maxdate"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","maxdate")
            kw["aname"] = "_maxdate"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_maxdate_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class datetype_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "datetype"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","datetype")
            kw["aname"] = "_datetype"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_datetype_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class term_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "term"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","term")
            kw["aname"] = "_term"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_term_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class dbfrom_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "dbfrom"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","dbfrom")
            kw["aname"] = "_dbfrom"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_dbfrom_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class WebEnv_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "WebEnv"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","WebEnv")
            kw["aname"] = "_WebEnv"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_WebEnv_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class query_key_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "query_key"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","query_key")
            kw["aname"] = "_query_key"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_query_key_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class cmd_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "cmd"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","cmd")
            kw["aname"] = "_cmd"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_cmd_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class tool_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "tool"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","tool")
            kw["aname"] = "_tool"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_tool_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class email_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "email"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","email")
            kw["aname"] = "_email"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_email_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class linkname_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "linkname"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","linkname")
            kw["aname"] = "_linkname"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_linkname_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class eLinkRequest_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "eLinkRequest"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/elink"
        def __init__(self, **kw):
            ns = ns3.eLinkRequest_Dec.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","db",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","id",lazy=True, isref=True)(minOccurs=0, maxOccurs="unbounded", nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","reldate",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","mindate",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","maxdate",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","datetype",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","term",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","dbfrom",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","linkname",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","WebEnv",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","query_key",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","cmd",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","tool",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","email",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/elink","eLinkRequest")
            kw["aname"] = "_eLinkRequest"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._db = None
                    self._id = None
                    self._reldate = None
                    self._mindate = None
                    self._maxdate = None
                    self._datetype = None
                    self._term = None
                    self._dbfrom = None
                    self._linkname = None
                    self._WebEnv = None
                    self._query_key = None
                    self._cmd = None
                    self._tool = None
                    self._email = None
                    return
            Holder.__name__ = "eLinkRequest_Holder"
            self.pyclass = Holder

# end class ns3 (tns: http://www.ncbi.nlm.nih.gov/soap/eutils/elink)

##############################
# targetNamespace
# http://www.ncbi.nlm.nih.gov/soap/eutils/einfo
##############################

class ns4:
    targetNamespace = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"

    class DbInfoType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"
        type = (schema, "DbInfoType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns4.DbInfoType_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"DbName"), aname="_DbName", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"MenuName"), aname="_MenuName", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Description"), aname="_Description", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Count"), aname="_Count", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"LastUpdate"), aname="_LastUpdate", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","FieldListType",lazy=True)(pname=(ns,"FieldList"), aname="_FieldList", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","LinkListType",lazy=True)(pname=(ns,"LinkList"), aname="_LinkList", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._DbName = None
                    self._MenuName = None
                    self._Description = None
                    self._Count = None
                    self._LastUpdate = None
                    self._FieldList = None
                    self._LinkList = None
                    return
            Holder.__name__ = "DbInfoType_Holder"
            self.pyclass = Holder

    class DbListType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"
        type = (schema, "DbListType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns4.DbListType_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"DbName"), aname="_DbName", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._DbName = []
                    return
            Holder.__name__ = "DbListType_Holder"
            self.pyclass = Holder

    class FieldType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"
        type = (schema, "FieldType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns4.FieldType_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"Name"), aname="_Name", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"FullName"), aname="_FullName", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Description"), aname="_Description", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"TermCount"), aname="_TermCount", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"IsDate"), aname="_IsDate", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"IsNumerical"), aname="_IsNumerical", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"SingleToken"), aname="_SingleToken", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Hierarchy"), aname="_Hierarchy", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"IsHidden"), aname="_IsHidden", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Name = None
                    self._FullName = None
                    self._Description = None
                    self._TermCount = None
                    self._IsDate = None
                    self._IsNumerical = None
                    self._SingleToken = None
                    self._Hierarchy = None
                    self._IsHidden = None
                    return
            Holder.__name__ = "FieldType_Holder"
            self.pyclass = Holder

    class FieldListType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"
        type = (schema, "FieldListType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns4.FieldListType_Def.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","FieldType",lazy=True)(pname=(ns,"Field"), aname="_Field", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Field = []
                    return
            Holder.__name__ = "FieldListType_Holder"
            self.pyclass = Holder

    class LinkType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"
        type = (schema, "LinkType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns4.LinkType_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"Name"), aname="_Name", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Menu"), aname="_Menu", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Description"), aname="_Description", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"DbTo"), aname="_DbTo", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Name = None
                    self._Menu = None
                    self._Description = None
                    self._DbTo = None
                    return
            Holder.__name__ = "LinkType_Holder"
            self.pyclass = Holder

    class LinkListType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"
        type = (schema, "LinkListType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns4.LinkListType_Def.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","LinkType",lazy=True)(pname=(ns,"Link"), aname="_Link", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Link = []
                    return
            Holder.__name__ = "LinkListType_Holder"
            self.pyclass = Holder

    class db_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "db"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","db")
            kw["aname"] = "_db"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_db_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class tool_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "tool"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","tool")
            kw["aname"] = "_tool"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_tool_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class email_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "email"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","email")
            kw["aname"] = "_email"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_email_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class eInfoRequest_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "eInfoRequest"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"
        def __init__(self, **kw):
            ns = ns4.eInfoRequest_Dec.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","db",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","tool",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","email",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","eInfoRequest")
            kw["aname"] = "_eInfoRequest"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._db = None
                    self._tool = None
                    self._email = None
                    return
            Holder.__name__ = "eInfoRequest_Holder"
            self.pyclass = Holder

    class eInfoResult_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "eInfoResult"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/einfo"
        def __init__(self, **kw):
            ns = ns4.eInfoResult_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ERROR"), aname="_ERROR", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","DbListType",lazy=True)(pname=(ns,"DbList"), aname="_DbList", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","DbInfoType",lazy=True)(pname=(ns,"DbInfo"), aname="_DbInfo", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/einfo","eInfoResult")
            kw["aname"] = "_eInfoResult"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ERROR = None
                    self._DbList = None
                    self._DbInfo = None
                    return
            Holder.__name__ = "eInfoResult_Holder"
            self.pyclass = Holder

# end class ns4 (tns: http://www.ncbi.nlm.nih.gov/soap/eutils/einfo)

##############################
# targetNamespace
# http://www.ncbi.nlm.nih.gov/soap/eutils/egquery
##############################

class ns5:
    targetNamespace = "http://www.ncbi.nlm.nih.gov/soap/eutils/egquery"

    class ResultItemType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/egquery"
        type = (schema, "ResultItemType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns5.ResultItemType_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"DbName"), aname="_DbName", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"MenuName"), aname="_MenuName", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Count"), aname="_Count", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Status"), aname="_Status", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._DbName = None
                    self._MenuName = None
                    self._Count = None
                    self._Status = None
                    return
            Holder.__name__ = "ResultItemType_Holder"
            self.pyclass = Holder

    class eGQueryResultType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/egquery"
        type = (schema, "eGQueryResultType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns5.eGQueryResultType_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"ERROR"), aname="_ERROR", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/egquery","ResultItemType",lazy=True)(pname=(ns,"ResultItem"), aname="_ResultItem", minOccurs=1, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ERROR = None
                    self._ResultItem = []
                    return
            Holder.__name__ = "eGQueryResultType_Holder"
            self.pyclass = Holder

    class Result_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "Result"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/egquery"
        def __init__(self, **kw):
            ns = ns5.Result_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"Term"), aname="_Term", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/egquery","eGQueryResultType",lazy=True)(pname=(ns,"eGQueryResult"), aname="_eGQueryResult", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/egquery","Result")
            kw["aname"] = "_Result"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Term = None
                    self._eGQueryResult = None
                    return
            Holder.__name__ = "Result_Holder"
            self.pyclass = Holder

    class term_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "term"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/egquery"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/egquery","term")
            kw["aname"] = "_term"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_term_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class tool_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "tool"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/egquery"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/egquery","tool")
            kw["aname"] = "_tool"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_tool_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class email_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "email"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/egquery"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/egquery","email")
            kw["aname"] = "_email"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_email_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class eGqueryRequest_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "eGqueryRequest"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/egquery"
        def __init__(self, **kw):
            ns = ns5.eGqueryRequest_Dec.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/egquery","term",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/egquery","tool",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/egquery","email",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/egquery","eGqueryRequest")
            kw["aname"] = "_eGqueryRequest"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._term = None
                    self._tool = None
                    self._email = None
                    return
            Holder.__name__ = "eGqueryRequest_Holder"
            self.pyclass = Holder

# end class ns5 (tns: http://www.ncbi.nlm.nih.gov/soap/eutils/egquery)

##############################
# targetNamespace
# http://www.ncbi.nlm.nih.gov/soap/eutils/esearch
##############################

class ns6:
    targetNamespace = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"

    class ErrorListType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        type = (schema, "ErrorListType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns6.ErrorListType_Def.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","PhraseNotFound",lazy=True, isref=True)(minOccurs=0, maxOccurs="unbounded", nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","FieldNotFound",lazy=True, isref=True)(minOccurs=0, maxOccurs="unbounded", nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._PhraseNotFound = None
                    self._FieldNotFound = None
                    return
            Holder.__name__ = "ErrorListType_Holder"
            self.pyclass = Holder

    class IdListType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        type = (schema, "IdListType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns6.IdListType_Def.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","Id",lazy=True, isref=True)(minOccurs=0, maxOccurs="unbounded", nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Id = None
                    return
            Holder.__name__ = "IdListType_Holder"
            self.pyclass = Holder

    class TermSetType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        type = (schema, "TermSetType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns6.TermSetType_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"Term"), aname="_Term", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Field"), aname="_Field", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","Count",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","Explode",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Term = None
                    self._Field = None
                    self._Count = None
                    self._Explode = None
                    return
            Holder.__name__ = "TermSetType_Holder"
            self.pyclass = Holder

    class TranslationType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        type = (schema, "TranslationType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns6.TranslationType_Def.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","From",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","To",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._From = None
                    self._To = None
                    return
            Holder.__name__ = "TranslationType_Holder"
            self.pyclass = Holder

    class TranslationSetType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        type = (schema, "TranslationSetType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns6.TranslationSetType_Def.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","TranslationType",lazy=True)(pname=(ns,"Translation"), aname="_Translation", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Translation = []
                    return
            Holder.__name__ = "TranslationSetType_Holder"
            self.pyclass = Holder

    class TranslationStackType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        type = (schema, "TranslationStackType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns6.TranslationStackType_Def.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","TermSetType",lazy=True)(pname=(ns,"TermSet"), aname="_TermSet", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"OP"), aname="_OP", minOccurs=0, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._TermSet = []
                    self._OP = []
                    return
            Holder.__name__ = "TranslationStackType_Holder"
            self.pyclass = Holder

    class WarningListType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        type = (schema, "WarningListType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns6.WarningListType_Def.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","PhraseIgnored",lazy=True, isref=True)(minOccurs=0, maxOccurs="unbounded", nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","QuotedPhraseNotFound",lazy=True, isref=True)(minOccurs=0, maxOccurs="unbounded", nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","OutputMessage",lazy=True, isref=True)(minOccurs=0, maxOccurs="unbounded", nillable=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._PhraseIgnored = None
                    self._QuotedPhraseNotFound = None
                    self._OutputMessage = None
                    return
            Holder.__name__ = "WarningListType_Holder"
            self.pyclass = Holder

    class Count_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Count"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","Count")
            kw["aname"] = "_Count"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Count_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class ERROR_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "ERROR"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","ERROR")
            kw["aname"] = "_ERROR"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_ERROR_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class Explode_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Explode"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","Explode")
            kw["aname"] = "_Explode"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Explode_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class FieldNotFound_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "FieldNotFound"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","FieldNotFound")
            kw["aname"] = "_FieldNotFound"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_FieldNotFound_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class From_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "From"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","From")
            kw["aname"] = "_From"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_From_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class Id_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Id"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","Id")
            kw["aname"] = "_Id"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Id_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class OutputMessage_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "OutputMessage"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","OutputMessage")
            kw["aname"] = "_OutputMessage"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_OutputMessage_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class PhraseIgnored_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "PhraseIgnored"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","PhraseIgnored")
            kw["aname"] = "_PhraseIgnored"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_PhraseIgnored_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class PhraseNotFound_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "PhraseNotFound"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","PhraseNotFound")
            kw["aname"] = "_PhraseNotFound"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_PhraseNotFound_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class QueryKey_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "QueryKey"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","QueryKey")
            kw["aname"] = "_QueryKey"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_QueryKey_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class QueryTranslation_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "QueryTranslation"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","QueryTranslation")
            kw["aname"] = "_QueryTranslation"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_QueryTranslation_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class QuotedPhraseNotFound_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "QuotedPhraseNotFound"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","QuotedPhraseNotFound")
            kw["aname"] = "_QuotedPhraseNotFound"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_QuotedPhraseNotFound_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class RetMax_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "RetMax"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","RetMax")
            kw["aname"] = "_RetMax"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_RetMax_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class RetStart_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "RetStart"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","RetStart")
            kw["aname"] = "_RetStart"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_RetStart_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class To_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "To"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","To")
            kw["aname"] = "_To"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_To_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class WebEnv_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "WebEnv"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","WebEnv")
            kw["aname"] = "_WebEnv"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_WebEnv_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class eSearchResult_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "eSearchResult"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            ns = ns6.eSearchResult_Dec.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","ERROR",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","Count",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","RetMax",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","RetStart",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","QueryKey",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","WebEnv",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","IdListType",lazy=True)(pname=(ns,"IdList"), aname="_IdList", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","TranslationSetType",lazy=True)(pname=(ns,"TranslationSet"), aname="_TranslationSet", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","TranslationStackType",lazy=True)(pname=(ns,"TranslationStack"), aname="_TranslationStack", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","QueryTranslation",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","ErrorListType",lazy=True)(pname=(ns,"ErrorList"), aname="_ErrorList", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","WarningListType",lazy=True)(pname=(ns,"WarningList"), aname="_WarningList", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","eSearchResult")
            kw["aname"] = "_eSearchResult"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ERROR = None
                    self._Count = None
                    self._RetMax = None
                    self._RetStart = None
                    self._QueryKey = None
                    self._WebEnv = None
                    self._IdList = None
                    self._TranslationSet = None
                    self._TranslationStack = None
                    self._QueryTranslation = None
                    self._ErrorList = None
                    self._WarningList = None
                    return
            Holder.__name__ = "eSearchResult_Holder"
            self.pyclass = Holder

    class db_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "db"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","db")
            kw["aname"] = "_db"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_db_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class term_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "term"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","term")
            kw["aname"] = "_term"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_term_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class usehistory_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "usehistory"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","usehistory")
            kw["aname"] = "_usehistory"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_usehistory_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class tool_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "tool"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","tool")
            kw["aname"] = "_tool"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_tool_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class email_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "email"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","email")
            kw["aname"] = "_email"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_email_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class field_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "field"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","field")
            kw["aname"] = "_field"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_field_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class reldate_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "reldate"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","reldate")
            kw["aname"] = "_reldate"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_reldate_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class mindate_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "mindate"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","mindate")
            kw["aname"] = "_mindate"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_mindate_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class maxdate_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "maxdate"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","maxdate")
            kw["aname"] = "_maxdate"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_maxdate_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class datetype_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "datetype"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","datetype")
            kw["aname"] = "_datetype"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_datetype_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class rettype_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "rettype"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","rettype")
            kw["aname"] = "_rettype"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_rettype_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class sort_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "sort"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","sort")
            kw["aname"] = "_sort"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_sort_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class eSearchRequest_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "eSearchRequest"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/esearch"
        def __init__(self, **kw):
            ns = ns6.eSearchRequest_Dec.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","db",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","term",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","WebEnv",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","QueryKey",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","usehistory",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","tool",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","email",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","field",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","reldate",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","mindate",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","maxdate",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","datetype",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","RetStart",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","RetMax",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","rettype",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","sort",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/esearch","eSearchRequest")
            kw["aname"] = "_eSearchRequest"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._db = None
                    self._term = None
                    self._WebEnv = None
                    self._QueryKey = None
                    self._usehistory = None
                    self._tool = None
                    self._email = None
                    self._field = None
                    self._reldate = None
                    self._mindate = None
                    self._maxdate = None
                    self._datetype = None
                    self._RetStart = None
                    self._RetMax = None
                    self._rettype = None
                    self._sort = None
                    return
            Holder.__name__ = "eSearchRequest_Holder"
            self.pyclass = Holder

# end class ns6 (tns: http://www.ncbi.nlm.nih.gov/soap/eutils/esearch)

##############################
# targetNamespace
# http://www.ncbi.nlm.nih.gov/soap/eutils/espell
##############################

class ns7:
    targetNamespace = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"

    class CorrectedQuery_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "CorrectedQuery"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","CorrectedQuery")
            kw["aname"] = "_CorrectedQuery"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_CorrectedQuery_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class Database_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Database"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","Database")
            kw["aname"] = "_Database"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Database_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class ERROR_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "ERROR"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","ERROR")
            kw["aname"] = "_ERROR"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_ERROR_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class Original_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Original"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","Original")
            kw["aname"] = "_Original"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Original_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class Query_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Query"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","Query")
            kw["aname"] = "_Query"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Query_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class Replaced_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "Replaced"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","Replaced")
            kw["aname"] = "_Replaced"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_Replaced_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class SpelledQuery_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "SpelledQuery"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            ns = ns7.SpelledQuery_Dec.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","Replaced",lazy=True, isref=True)(minOccurs=0, maxOccurs="unbounded", nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","Original",lazy=True, isref=True)(minOccurs=0, maxOccurs="unbounded", nillable=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","SpelledQuery")
            kw["aname"] = "_SpelledQuery"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Replaced = None
                    self._Original = None
                    return
            Holder.__name__ = "SpelledQuery_Holder"
            self.pyclass = Holder

    class eSpellResult_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "eSpellResult"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            ns = ns7.eSpellResult_Dec.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","Database",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","Query",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","CorrectedQuery",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","SpelledQuery",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","ERROR",lazy=True, isref=True)(minOccurs=1, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","eSpellResult")
            kw["aname"] = "_eSpellResult"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Database = None
                    self._Query = None
                    self._CorrectedQuery = None
                    self._SpelledQuery = None
                    self._ERROR = None
                    return
            Holder.__name__ = "eSpellResult_Holder"
            self.pyclass = Holder

    class db_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "db"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","db")
            kw["aname"] = "_db"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_db_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class term_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "term"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","term")
            kw["aname"] = "_term"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_term_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class tool_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "tool"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","tool")
            kw["aname"] = "_tool"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_tool_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class email_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "email"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","email")
            kw["aname"] = "_email"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_email_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class eSpellRequest_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "eSpellRequest"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/espell"
        def __init__(self, **kw):
            ns = ns7.eSpellRequest_Dec.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","db",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","term",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","tool",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","email",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/espell","eSpellRequest")
            kw["aname"] = "_eSpellRequest"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._db = None
                    self._term = None
                    self._tool = None
                    self._email = None
                    return
            Holder.__name__ = "eSpellRequest_Holder"
            self.pyclass = Holder

# end class ns7 (tns: http://www.ncbi.nlm.nih.gov/soap/eutils/espell)

##############################
# targetNamespace
# http://www.ncbi.nlm.nih.gov/soap/eutils/epost
##############################

class ns1:
    targetNamespace = "http://www.ncbi.nlm.nih.gov/soap/eutils/epost"

    class InvalidIdListType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/epost"
        type = (schema, "InvalidIdListType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns1.InvalidIdListType_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"Id"), aname="_Id", minOccurs=1, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Id = []
                    return
            Holder.__name__ = "InvalidIdListType_Holder"
            self.pyclass = Holder

    class ePostResult_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "ePostResult"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/epost"
        def __init__(self, **kw):
            ns = ns1.ePostResult_Dec.schema
            TClist = [GTD("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","InvalidIdListType",lazy=True)(pname=(ns,"InvalidIdList"), aname="_InvalidIdList", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"QueryKey"), aname="_QueryKey", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"WebEnv"), aname="_WebEnv", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"ERROR"), aname="_ERROR", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","ePostResult")
            kw["aname"] = "_ePostResult"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._InvalidIdList = None
                    self._QueryKey = None
                    self._WebEnv = None
                    self._ERROR = None
                    return
            Holder.__name__ = "ePostResult_Holder"
            self.pyclass = Holder

    class db_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "db"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/epost"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","db")
            kw["aname"] = "_db"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_db_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class id_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "id"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/epost"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","id")
            kw["aname"] = "_id"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_id_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class WebEnv_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "WebEnv"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/epost"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","WebEnv")
            kw["aname"] = "_WebEnv"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_WebEnv_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class tool_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "tool"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/epost"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","tool")
            kw["aname"] = "_tool"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_tool_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class email_Dec(ZSI.TC.String, ElementDeclaration):
        literal = "email"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/epost"
        def __init__(self, **kw):
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","email")
            kw["aname"] = "_email"
            class IHolder(str): typecode=self
            kw["pyclass"] = IHolder
            IHolder.__name__ = "_email_immutable_holder"
            ZSI.TC.String.__init__(self, **kw)

    class ePostRequest_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "ePostRequest"
        schema = "http://www.ncbi.nlm.nih.gov/soap/eutils/epost"
        def __init__(self, **kw):
            ns = ns1.ePostRequest_Dec.schema
            TClist = [GED("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","db",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","id",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","WebEnv",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","tool",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded")), GED("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","email",lazy=True, isref=True)(minOccurs=0, maxOccurs=1, nillable=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://www.ncbi.nlm.nih.gov/soap/eutils/epost","ePostRequest")
            kw["aname"] = "_ePostRequest"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._db = None
                    self._id = None
                    self._WebEnv = None
                    self._tool = None
                    self._email = None
                    return
            Holder.__name__ = "ePostRequest_Holder"
            self.pyclass = Holder

# end class ns1 (tns: http://www.ncbi.nlm.nih.gov/soap/eutils/epost)
