##################################################
# file: PUG_types.py
#
# schema types generated by "ZSI.generate.wsdl2python.WriteServiceModule"
#    /usr/local/bin/wsdl2py --complexType pug_soap.cgi.xml
#
##################################################

import ZSI
import ZSI.TCcompound
from ZSI.schema import LocalElementDeclaration, ElementDeclaration, TypeDefinition, GTD, GED
from ZSI.generate.pyclass import pyclass_type

##############################
# targetNamespace
# http://pubchem.ncbi.nlm.nih.gov/
##############################

class ns0:
    targetNamespace = "http://pubchem.ncbi.nlm.nih.gov/"

    class FormatType_Def(ZSI.TC.String, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "FormatType")
        def __init__(self, pname, **kw):
            ZSI.TC.String.__init__(self, pname, pyclass=None, **kw)
            class Holder(str):
                typecode = self
            self.pyclass = Holder

    class ArrayOfInt_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "ArrayOfInt")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.ArrayOfInt_Def.schema
            TClist = [ZSI.TCnumbers.Iint(pname=(ns,"int"), aname="_int", minOccurs=1, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._int = []
                    return
            Holder.__name__ = "ArrayOfInt_Holder"
            self.pyclass = Holder

    class PCIDType_Def(ZSI.TC.String, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "PCIDType")
        def __init__(self, pname, **kw):
            ZSI.TC.String.__init__(self, pname, pyclass=None, **kw)
            class Holder(str):
                typecode = self
            self.pyclass = Holder

    class EntrezKey_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "EntrezKey")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.EntrezKey_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"db"), aname="_db", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"key"), aname="_key", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"webenv"), aname="_webenv", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._db = None
                    self._key = None
                    self._webenv = None
                    return
            Holder.__name__ = "EntrezKey_Holder"
            self.pyclass = Holder

    class IdentitySearchOptions_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "IdentitySearchOptions")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.IdentitySearchOptions_Def.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","IdentityType",lazy=False)(pname=(ns,"eIdentity"), aname="_eIdentity", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"ToWebEnv"), aname="_ToWebEnv", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._eIdentity = None
                    self._ToWebEnv = None
                    return
            Holder.__name__ = "IdentitySearchOptions_Holder"
            self.pyclass = Holder

    class IdentityType_Def(ZSI.TC.String, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "IdentityType")
        def __init__(self, pname, **kw):
            ZSI.TC.String.__init__(self, pname, pyclass=None, **kw)
            class Holder(str):
                typecode = self
            self.pyclass = Holder

    class LimitsType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "LimitsType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.LimitsType_Def.schema
            TClist = [ZSI.TCnumbers.Iint(pname=(ns,"seconds"), aname="_seconds", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TCnumbers.Iint(pname=(ns,"maxRecords"), aname="_maxRecords", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._seconds = None
                    self._maxRecords = None
                    self._ListKey = None
                    return
            Holder.__name__ = "LimitsType_Holder"
            self.pyclass = Holder

    class StructureSearchOptions_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "StructureSearchOptions")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.StructureSearchOptions_Def.schema
            TClist = [ZSI.TC.Boolean(pname=(ns,"MatchIsotopes"), aname="_MatchIsotopes", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.Boolean(pname=(ns,"MatchCharges"), aname="_MatchCharges", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.Boolean(pname=(ns,"MatchTautomers"), aname="_MatchTautomers", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.Boolean(pname=(ns,"RingsNotEmbedded"), aname="_RingsNotEmbedded", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.Boolean(pname=(ns,"SingeDoubleBondsMatch"), aname="_SingeDoubleBondsMatch", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.Boolean(pname=(ns,"ChainsMatchRings"), aname="_ChainsMatchRings", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.Boolean(pname=(ns,"StripHydrogen"), aname="_StripHydrogen", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","StereoType",lazy=False)(pname=(ns,"eStereo"), aname="_eStereo", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"ToWebEnv"), aname="_ToWebEnv", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._MatchIsotopes = None
                    self._MatchCharges = None
                    self._MatchTautomers = None
                    self._RingsNotEmbedded = None
                    self._SingeDoubleBondsMatch = None
                    self._ChainsMatchRings = None
                    self._StripHydrogen = None
                    self._eStereo = None
                    self._ToWebEnv = None
                    return
            Holder.__name__ = "StructureSearchOptions_Holder"
            self.pyclass = Holder

    class StereoType_Def(ZSI.TC.String, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "StereoType")
        def __init__(self, pname, **kw):
            ZSI.TC.String.__init__(self, pname, pyclass=None, **kw)
            class Holder(str):
                typecode = self
            self.pyclass = Holder

    class SimilaritySearchOptions_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "SimilaritySearchOptions")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.SimilaritySearchOptions_Def.schema
            TClist = [ZSI.TCnumbers.Iint(pname=(ns,"threshold"), aname="_threshold", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"ToWebEnv"), aname="_ToWebEnv", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._threshold = None
                    self._ToWebEnv = None
                    return
            Holder.__name__ = "SimilaritySearchOptions_Holder"
            self.pyclass = Holder

    class MFSearchOptions_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "MFSearchOptions")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.MFSearchOptions_Def.schema
            TClist = [ZSI.TC.Boolean(pname=(ns,"AllowOtherElements"), aname="_AllowOtherElements", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"ToWebEnv"), aname="_ToWebEnv", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._AllowOtherElements = None
                    self._ToWebEnv = None
                    return
            Holder.__name__ = "MFSearchOptions_Holder"
            self.pyclass = Holder

    class AnyKeyType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "AnyKeyType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.AnyKeyType_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"AnyKey"), aname="_AnyKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._AnyKey = None
                    return
            Holder.__name__ = "AnyKeyType_Holder"
            self.pyclass = Holder

    class StatusType_Def(ZSI.TC.String, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "StatusType")
        def __init__(self, pname, **kw):
            ZSI.TC.String.__init__(self, pname, pyclass=None, **kw)
            class Holder(str):
                typecode = self
            self.pyclass = Holder

    class CompressType_Def(ZSI.TC.String, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "CompressType")
        def __init__(self, pname, **kw):
            ZSI.TC.String.__init__(self, pname, pyclass=None, **kw)
            class Holder(str):
                typecode = self
            self.pyclass = Holder

    class AssayDescriptionType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "AssayDescriptionType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.AssayDescriptionType_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"Name"), aname="_Name", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","ArrayOfString",lazy=False)(pname=(ns,"Description"), aname="_Description", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","ArrayOfString",lazy=False)(pname=(ns,"Protocol"), aname="_Protocol", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","ArrayOfString",lazy=False)(pname=(ns,"Comment"), aname="_Comment", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TCnumbers.Iint(pname=(ns,"NumberOfTIDs"), aname="_NumberOfTIDs", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.Boolean(pname=(ns,"HasScore"), aname="_HasScore", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Method"), aname="_Method", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","ArrayOfTargets",lazy=False)(pname=(ns,"Targets"), aname="_Targets", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Name = None
                    self._Description = None
                    self._Protocol = None
                    self._Comment = None
                    self._NumberOfTIDs = None
                    self._HasScore = None
                    self._Method = None
                    self._Targets = None
                    return
            Holder.__name__ = "AssayDescriptionType_Holder"
            self.pyclass = Holder

    class ArrayOfString_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "ArrayOfString")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.ArrayOfString_Def.schema
            TClist = [ZSI.TC.String(pname=(ns,"string"), aname="_string", minOccurs=1, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._string = []
                    return
            Holder.__name__ = "ArrayOfString_Holder"
            self.pyclass = Holder

    class ArrayOfTargets_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "ArrayOfTargets")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.ArrayOfTargets_Def.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","AssayTargetType",lazy=False)(pname=(ns,"Target"), aname="_Target", minOccurs=1, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Target = []
                    return
            Holder.__name__ = "ArrayOfTargets_Holder"
            self.pyclass = Holder

    class AssayTargetType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "AssayTargetType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.AssayTargetType_Def.schema
            TClist = [ZSI.TCnumbers.Iint(pname=(ns,"gi"), aname="_gi", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Name"), aname="_Name", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._gi = None
                    self._Name = None
                    return
            Holder.__name__ = "AssayTargetType_Holder"
            self.pyclass = Holder

    class HeadingType_Def(ZSI.TC.String, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "HeadingType")
        def __init__(self, pname, **kw):
            ZSI.TC.String.__init__(self, pname, pyclass=None, **kw)
            class Holder(str):
                typecode = self
            self.pyclass = Holder

    class ColumnDescriptionType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "ColumnDescriptionType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.ColumnDescriptionType_Def.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","HeadingType",lazy=False)(pname=(ns,"Heading"), aname="_Heading", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TCnumbers.Iint(pname=(ns,"TID"), aname="_TID", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Name"), aname="_Name", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","ArrayOfString",lazy=False)(pname=(ns,"Description"), aname="_Description", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Type"), aname="_Type", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Unit"), aname="_Unit", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","TestedConcentrationType",lazy=False)(pname=(ns,"TestedConcentration"), aname="_TestedConcentration", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.Boolean(pname=(ns,"ActiveConcentration"), aname="_ActiveConcentration", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Heading = None
                    self._TID = None
                    self._Name = None
                    self._Description = None
                    self._Type = None
                    self._Unit = None
                    self._TestedConcentration = None
                    self._ActiveConcentration = None
                    return
            Holder.__name__ = "ColumnDescriptionType_Holder"
            self.pyclass = Holder

    class TestedConcentrationType_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "TestedConcentrationType")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.TestedConcentrationType_Def.schema
            TClist = [ZSI.TCnumbers.FPdouble(pname=(ns,"Concentration"), aname="_Concentration", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"Unit"), aname="_Unit", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._Concentration = None
                    self._Unit = None
                    return
            Holder.__name__ = "TestedConcentrationType_Holder"
            self.pyclass = Holder

    class AssayColumnsType_Def(ZSI.TC.String, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "AssayColumnsType")
        def __init__(self, pname, **kw):
            ZSI.TC.String.__init__(self, pname, pyclass=None, **kw)
            class Holder(str):
                typecode = self
            self.pyclass = Holder

    class AssayFormatType_Def(ZSI.TC.String, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "AssayFormatType")
        def __init__(self, pname, **kw):
            ZSI.TC.String.__init__(self, pname, pyclass=None, **kw)
            class Holder(str):
                typecode = self
            self.pyclass = Holder

    class ScoreTypeType_Def(ZSI.TC.String, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "ScoreTypeType")
        def __init__(self, pname, **kw):
            ZSI.TC.String.__init__(self, pname, pyclass=None, **kw)
            class Holder(str):
                typecode = self
            self.pyclass = Holder

    class MatrixFormatType_Def(ZSI.TC.String, TypeDefinition):
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        type = (schema, "MatrixFormatType")
        def __init__(self, pname, **kw):
            ZSI.TC.String.__init__(self, pname, pyclass=None, **kw)
            class Holder(str):
                typecode = self
            self.pyclass = Holder

    class InputStructure_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputStructure"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputStructure_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"structure"), aname="_structure", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","FormatType",lazy=False)(pname=(ns,"format"), aname="_format", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputStructure")
            kw["aname"] = "_InputStructure"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._structure = None
                    self._format = None
                    return
            Holder.__name__ = "InputStructure_Holder"
            self.pyclass = Holder

    class InputStructureResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputStructureResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputStructureResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"StrKey"), aname="_StrKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputStructureResponse")
            kw["aname"] = "_InputStructureResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._StrKey = None
                    return
            Holder.__name__ = "InputStructureResponse_Holder"
            self.pyclass = Holder

    class InputStructureBase64_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputStructureBase64"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputStructureBase64_Dec.schema
            TClist = [ZSI.TC.Base64String(pname=(ns,"structure"), aname="_structure", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","FormatType",lazy=False)(pname=(ns,"format"), aname="_format", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputStructureBase64")
            kw["aname"] = "_InputStructureBase64"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._structure = None
                    self._format = None
                    return
            Holder.__name__ = "InputStructureBase64_Holder"
            self.pyclass = Holder

    class InputStructureBase64Response_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputStructureBase64Response"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputStructureBase64Response_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"StrKey"), aname="_StrKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputStructureBase64Response")
            kw["aname"] = "_InputStructureBase64Response"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._StrKey = None
                    return
            Holder.__name__ = "InputStructureBase64Response_Holder"
            self.pyclass = Holder

    class InputList_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputList"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputList_Dec.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","ArrayOfInt",lazy=False)(pname=(ns,"ids"), aname="_ids", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","PCIDType",lazy=False)(pname=(ns,"idType"), aname="_idType", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputList")
            kw["aname"] = "_InputList"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ids = None
                    self._idType = None
                    return
            Holder.__name__ = "InputList_Holder"
            self.pyclass = Holder

    class InputListResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputListResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputListResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputListResponse")
            kw["aname"] = "_InputListResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    return
            Holder.__name__ = "InputListResponse_Holder"
            self.pyclass = Holder

    class InputListText_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputListText"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputListText_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ids"), aname="_ids", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","PCIDType",lazy=False)(pname=(ns,"idType"), aname="_idType", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputListText")
            kw["aname"] = "_InputListText"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ids = None
                    self._idType = None
                    return
            Holder.__name__ = "InputListText_Holder"
            self.pyclass = Holder

    class InputListTextResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputListTextResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputListTextResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputListTextResponse")
            kw["aname"] = "_InputListTextResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    return
            Holder.__name__ = "InputListTextResponse_Holder"
            self.pyclass = Holder

    class InputEntrez_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputEntrez"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputEntrez_Dec.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","EntrezKey",lazy=False)(pname=(ns,"EntrezKey"), aname="_EntrezKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputEntrez")
            kw["aname"] = "_InputEntrez"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._EntrezKey = None
                    return
            Holder.__name__ = "InputEntrez_Holder"
            self.pyclass = Holder

    class InputEntrezResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputEntrezResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputEntrezResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputEntrezResponse")
            kw["aname"] = "_InputEntrezResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    return
            Holder.__name__ = "InputEntrezResponse_Holder"
            self.pyclass = Holder

    class IdentitySearch_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "IdentitySearch"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.IdentitySearch_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"StrKey"), aname="_StrKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","IdentitySearchOptions",lazy=False)(pname=(ns,"idOptions"), aname="_idOptions", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","LimitsType",lazy=False)(pname=(ns,"limits"), aname="_limits", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","IdentitySearch")
            kw["aname"] = "_IdentitySearch"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._StrKey = None
                    self._idOptions = None
                    self._limits = None
                    return
            Holder.__name__ = "IdentitySearch_Holder"
            self.pyclass = Holder

    class IdentitySearchResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "IdentitySearchResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.IdentitySearchResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","IdentitySearchResponse")
            kw["aname"] = "_IdentitySearchResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    return
            Holder.__name__ = "IdentitySearchResponse_Holder"
            self.pyclass = Holder

    class SubstructureSearch_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "SubstructureSearch"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.SubstructureSearch_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"StrKey"), aname="_StrKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","StructureSearchOptions",lazy=False)(pname=(ns,"ssOptions"), aname="_ssOptions", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","LimitsType",lazy=False)(pname=(ns,"limits"), aname="_limits", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","SubstructureSearch")
            kw["aname"] = "_SubstructureSearch"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._StrKey = None
                    self._ssOptions = None
                    self._limits = None
                    return
            Holder.__name__ = "SubstructureSearch_Holder"
            self.pyclass = Holder

    class SubstructureSearchResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "SubstructureSearchResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.SubstructureSearchResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","SubstructureSearchResponse")
            kw["aname"] = "_SubstructureSearchResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    return
            Holder.__name__ = "SubstructureSearchResponse_Holder"
            self.pyclass = Holder

    class SuperstructureSearch_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "SuperstructureSearch"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.SuperstructureSearch_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"StrKey"), aname="_StrKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","StructureSearchOptions",lazy=False)(pname=(ns,"ssOptions"), aname="_ssOptions", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","LimitsType",lazy=False)(pname=(ns,"limits"), aname="_limits", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","SuperstructureSearch")
            kw["aname"] = "_SuperstructureSearch"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._StrKey = None
                    self._ssOptions = None
                    self._limits = None
                    return
            Holder.__name__ = "SuperstructureSearch_Holder"
            self.pyclass = Holder

    class SuperstructureSearchResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "SuperstructureSearchResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.SuperstructureSearchResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","SuperstructureSearchResponse")
            kw["aname"] = "_SuperstructureSearchResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    return
            Holder.__name__ = "SuperstructureSearchResponse_Holder"
            self.pyclass = Holder

    class SimilaritySearch2D_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "SimilaritySearch2D"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.SimilaritySearch2D_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"StrKey"), aname="_StrKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","SimilaritySearchOptions",lazy=False)(pname=(ns,"simOptions"), aname="_simOptions", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","LimitsType",lazy=False)(pname=(ns,"limits"), aname="_limits", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","SimilaritySearch2D")
            kw["aname"] = "_SimilaritySearch2D"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._StrKey = None
                    self._simOptions = None
                    self._limits = None
                    return
            Holder.__name__ = "SimilaritySearch2D_Holder"
            self.pyclass = Holder

    class SimilaritySearch2DResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "SimilaritySearch2DResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.SimilaritySearch2DResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","SimilaritySearch2DResponse")
            kw["aname"] = "_SimilaritySearch2DResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    return
            Holder.__name__ = "SimilaritySearch2DResponse_Holder"
            self.pyclass = Holder

    class MFSearch_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "MFSearch"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.MFSearch_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"MF"), aname="_MF", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","MFSearchOptions",lazy=False)(pname=(ns,"mfOptions"), aname="_mfOptions", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","LimitsType",lazy=False)(pname=(ns,"limits"), aname="_limits", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","MFSearch")
            kw["aname"] = "_MFSearch"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._MF = None
                    self._mfOptions = None
                    self._limits = None
                    return
            Holder.__name__ = "MFSearch_Holder"
            self.pyclass = Holder

    class MFSearchResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "MFSearchResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.MFSearchResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","MFSearchResponse")
            kw["aname"] = "_MFSearchResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    return
            Holder.__name__ = "MFSearchResponse_Holder"
            self.pyclass = Holder

    class Standardize_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "Standardize"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.Standardize_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"StrKey"), aname="_StrKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","Standardize")
            kw["aname"] = "_Standardize"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._StrKey = None
                    return
            Holder.__name__ = "Standardize_Holder"
            self.pyclass = Holder

    class StandardizeResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "StandardizeResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.StandardizeResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"StrKey"), aname="_StrKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","StandardizeResponse")
            kw["aname"] = "_StandardizeResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._StrKey = None
                    return
            Holder.__name__ = "StandardizeResponse_Holder"
            self.pyclass = Holder

    class GetStandardizedCID_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetStandardizedCID"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetStandardizedCID_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"StrKey"), aname="_StrKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetStandardizedCID")
            kw["aname"] = "_GetStandardizedCID"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._StrKey = None
                    return
            Holder.__name__ = "GetStandardizedCID_Holder"
            self.pyclass = Holder

    class GetStandardizedCIDResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetStandardizedCIDResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetStandardizedCIDResponse_Dec.schema
            TClist = [ZSI.TCnumbers.Iint(pname=(ns,"CID"), aname="_CID", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetStandardizedCIDResponse")
            kw["aname"] = "_GetStandardizedCIDResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._CID = None
                    return
            Holder.__name__ = "GetStandardizedCIDResponse_Holder"
            self.pyclass = Holder

    class GetStandardizedStructure_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetStandardizedStructure"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetStandardizedStructure_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"StrKey"), aname="_StrKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","FormatType",lazy=False)(pname=(ns,"format"), aname="_format", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetStandardizedStructure")
            kw["aname"] = "_GetStandardizedStructure"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._StrKey = None
                    self._format = None
                    return
            Holder.__name__ = "GetStandardizedStructure_Holder"
            self.pyclass = Holder

    class GetStandardizedStructureResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetStandardizedStructureResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetStandardizedStructureResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"structure"), aname="_structure", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetStandardizedStructureResponse")
            kw["aname"] = "_GetStandardizedStructureResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._structure = None
                    return
            Holder.__name__ = "GetStandardizedStructureResponse_Holder"
            self.pyclass = Holder

    class GetStandardizedStructureBase64_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetStandardizedStructureBase64"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetStandardizedStructureBase64_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"StrKey"), aname="_StrKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","FormatType",lazy=False)(pname=(ns,"format"), aname="_format", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetStandardizedStructureBase64")
            kw["aname"] = "_GetStandardizedStructureBase64"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._StrKey = None
                    self._format = None
                    return
            Holder.__name__ = "GetStandardizedStructureBase64_Holder"
            self.pyclass = Holder

    class GetStandardizedStructureBase64Response_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetStandardizedStructureBase64Response"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetStandardizedStructureBase64Response_Dec.schema
            TClist = [ZSI.TC.Base64String(pname=(ns,"structure"), aname="_structure", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetStandardizedStructureBase64Response")
            kw["aname"] = "_GetStandardizedStructureBase64Response"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._structure = None
                    return
            Holder.__name__ = "GetStandardizedStructureBase64Response_Holder"
            self.pyclass = Holder

    class GetOperationStatus_Dec(ElementDeclaration):
        literal = "GetOperationStatus"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        substitutionGroup = None
        def __init__(self, **kw):
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetOperationStatus")
            kw["aname"] = "_GetOperationStatus"
            if ns0.AnyKeyType_Def not in ns0.GetOperationStatus_Dec.__bases__:
                bases = list(ns0.GetOperationStatus_Dec.__bases__)
                bases.insert(0, ns0.AnyKeyType_Def)
                ns0.GetOperationStatus_Dec.__bases__ = tuple(bases)

            ns0.AnyKeyType_Def.__init__(self, **kw)
            if self.pyclass is not None: self.pyclass.__name__ = "GetOperationStatus_Dec_Holder"

    class GetOperationStatusResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetOperationStatusResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetOperationStatusResponse_Dec.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","StatusType",lazy=False)(pname=(ns,"status"), aname="_status", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetOperationStatusResponse")
            kw["aname"] = "_GetOperationStatusResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._status = None
                    return
            Holder.__name__ = "GetOperationStatusResponse_Holder"
            self.pyclass = Holder

    class GetStatusMessage_Dec(ElementDeclaration):
        literal = "GetStatusMessage"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        substitutionGroup = None
        def __init__(self, **kw):
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetStatusMessage")
            kw["aname"] = "_GetStatusMessage"
            if ns0.AnyKeyType_Def not in ns0.GetStatusMessage_Dec.__bases__:
                bases = list(ns0.GetStatusMessage_Dec.__bases__)
                bases.insert(0, ns0.AnyKeyType_Def)
                ns0.GetStatusMessage_Dec.__bases__ = tuple(bases)

            ns0.AnyKeyType_Def.__init__(self, **kw)
            if self.pyclass is not None: self.pyclass.__name__ = "GetStatusMessage_Dec_Holder"

    class GetStatusMessageResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetStatusMessageResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetStatusMessageResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"message"), aname="_message", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetStatusMessageResponse")
            kw["aname"] = "_GetStatusMessageResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._message = None
                    return
            Holder.__name__ = "GetStatusMessageResponse_Holder"
            self.pyclass = Holder

    class GetListItemsCount_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetListItemsCount"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetListItemsCount_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetListItemsCount")
            kw["aname"] = "_GetListItemsCount"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    return
            Holder.__name__ = "GetListItemsCount_Holder"
            self.pyclass = Holder

    class GetListItemsCountResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetListItemsCountResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetListItemsCountResponse_Dec.schema
            TClist = [ZSI.TCnumbers.Iint(pname=(ns,"count"), aname="_count", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetListItemsCountResponse")
            kw["aname"] = "_GetListItemsCountResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._count = None
                    return
            Holder.__name__ = "GetListItemsCountResponse_Holder"
            self.pyclass = Holder

    class GetEntrezKey_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetEntrezKey"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetEntrezKey_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetEntrezKey")
            kw["aname"] = "_GetEntrezKey"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    return
            Holder.__name__ = "GetEntrezKey_Holder"
            self.pyclass = Holder

    class GetEntrezKeyResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetEntrezKeyResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetEntrezKeyResponse_Dec.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","EntrezKey",lazy=False)(pname=(ns,"EntrezKey"), aname="_EntrezKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetEntrezKeyResponse")
            kw["aname"] = "_GetEntrezKeyResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._EntrezKey = None
                    return
            Holder.__name__ = "GetEntrezKeyResponse_Holder"
            self.pyclass = Holder

    class GetEntrezUrl_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetEntrezUrl"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetEntrezUrl_Dec.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","EntrezKey",lazy=False)(pname=(ns,"EntrezKey"), aname="_EntrezKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetEntrezUrl")
            kw["aname"] = "_GetEntrezUrl"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._EntrezKey = None
                    return
            Holder.__name__ = "GetEntrezUrl_Holder"
            self.pyclass = Holder

    class GetEntrezUrlResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetEntrezUrlResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetEntrezUrlResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"url"), aname="_url", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetEntrezUrlResponse")
            kw["aname"] = "_GetEntrezUrlResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._url = None
                    return
            Holder.__name__ = "GetEntrezUrlResponse_Holder"
            self.pyclass = Holder

    class Download_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "Download"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.Download_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","FormatType",lazy=False)(pname=(ns,"eFormat"), aname="_eFormat", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","CompressType",lazy=False)(pname=(ns,"eCompress"), aname="_eCompress", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","Download")
            kw["aname"] = "_Download"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    self._eFormat = None
                    self._eCompress = None
                    return
            Holder.__name__ = "Download_Holder"
            self.pyclass = Holder

    class DownloadResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "DownloadResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.DownloadResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"DownloadKey"), aname="_DownloadKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","DownloadResponse")
            kw["aname"] = "_DownloadResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._DownloadKey = None
                    return
            Holder.__name__ = "DownloadResponse_Holder"
            self.pyclass = Holder

    class GetDownloadUrl_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetDownloadUrl"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetDownloadUrl_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"DownloadKey"), aname="_DownloadKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetDownloadUrl")
            kw["aname"] = "_GetDownloadUrl"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._DownloadKey = None
                    return
            Holder.__name__ = "GetDownloadUrl_Holder"
            self.pyclass = Holder

    class GetDownloadUrlResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetDownloadUrlResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetDownloadUrlResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"url"), aname="_url", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetDownloadUrlResponse")
            kw["aname"] = "_GetDownloadUrlResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._url = None
                    return
            Holder.__name__ = "GetDownloadUrlResponse_Holder"
            self.pyclass = Holder

    class GetIDList_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetIDList"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetIDList_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetIDList")
            kw["aname"] = "_GetIDList"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    return
            Holder.__name__ = "GetIDList_Holder"
            self.pyclass = Holder

    class GetIDListResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetIDListResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetIDListResponse_Dec.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","ArrayOfInt",lazy=False)(pname=(ns,"IDList"), aname="_IDList", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetIDListResponse")
            kw["aname"] = "_GetIDListResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._IDList = None
                    return
            Holder.__name__ = "GetIDListResponse_Holder"
            self.pyclass = Holder

    class GetAssayDescription_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetAssayDescription"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetAssayDescription_Dec.schema
            TClist = [ZSI.TCnumbers.Iint(pname=(ns,"AID"), aname="_AID", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetAssayDescription")
            kw["aname"] = "_GetAssayDescription"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._AID = None
                    return
            Holder.__name__ = "GetAssayDescription_Holder"
            self.pyclass = Holder

    class GetAssayDescriptionResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetAssayDescriptionResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetAssayDescriptionResponse_Dec.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","AssayDescriptionType",lazy=False)(pname=(ns,"AssayDescription"), aname="_AssayDescription", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetAssayDescriptionResponse")
            kw["aname"] = "_GetAssayDescriptionResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._AssayDescription = None
                    return
            Holder.__name__ = "GetAssayDescriptionResponse_Holder"
            self.pyclass = Holder

    class GetAssayColumnDescription_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetAssayColumnDescription"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetAssayColumnDescription_Dec.schema
            TClist = [ZSI.TCnumbers.Iint(pname=(ns,"AID"), aname="_AID", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","HeadingType",lazy=False)(pname=(ns,"Heading"), aname="_Heading", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TCnumbers.Iint(pname=(ns,"TID"), aname="_TID", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetAssayColumnDescription")
            kw["aname"] = "_GetAssayColumnDescription"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._AID = None
                    self._Heading = None
                    self._TID = None
                    return
            Holder.__name__ = "GetAssayColumnDescription_Holder"
            self.pyclass = Holder

    class GetAssayColumnDescriptionResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetAssayColumnDescriptionResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetAssayColumnDescriptionResponse_Dec.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","ColumnDescriptionType",lazy=False)(pname=(ns,"ColumnDescription"), aname="_ColumnDescription", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetAssayColumnDescriptionResponse")
            kw["aname"] = "_GetAssayColumnDescriptionResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ColumnDescription = None
                    return
            Holder.__name__ = "GetAssayColumnDescriptionResponse_Holder"
            self.pyclass = Holder

    class GetAssayColumnDescriptions_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetAssayColumnDescriptions"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetAssayColumnDescriptions_Dec.schema
            TClist = [ZSI.TCnumbers.Iint(pname=(ns,"AID"), aname="_AID", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetAssayColumnDescriptions")
            kw["aname"] = "_GetAssayColumnDescriptions"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._AID = None
                    return
            Holder.__name__ = "GetAssayColumnDescriptions_Holder"
            self.pyclass = Holder

    class GetAssayColumnDescriptionsResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "GetAssayColumnDescriptionsResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.GetAssayColumnDescriptionsResponse_Dec.schema
            TClist = [GTD("http://pubchem.ncbi.nlm.nih.gov/","ColumnDescriptionType",lazy=False)(pname=(ns,"ColumnDescription"), aname="_ColumnDescription", minOccurs=1, maxOccurs="unbounded", nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","GetAssayColumnDescriptionsResponse")
            kw["aname"] = "_GetAssayColumnDescriptionsResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ColumnDescription = []
                    return
            Holder.__name__ = "GetAssayColumnDescriptionsResponse_Holder"
            self.pyclass = Holder

    class InputAssay_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputAssay"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputAssay_Dec.schema
            TClist = [ZSI.TCnumbers.Iint(pname=(ns,"AID"), aname="_AID", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","AssayColumnsType",lazy=False)(pname=(ns,"Columns"), aname="_Columns", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"ListKeyTIDs"), aname="_ListKeyTIDs", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"ListKeySCIDs"), aname="_ListKeySCIDs", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputAssay")
            kw["aname"] = "_InputAssay"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._AID = None
                    self._Columns = None
                    self._ListKeyTIDs = None
                    self._ListKeySCIDs = None
                    return
            Holder.__name__ = "InputAssay_Holder"
            self.pyclass = Holder

    class InputAssayResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "InputAssayResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.InputAssayResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"AssayKey"), aname="_AssayKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","InputAssayResponse")
            kw["aname"] = "_InputAssayResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._AssayKey = None
                    return
            Holder.__name__ = "InputAssayResponse_Holder"
            self.pyclass = Holder

    class AssayDownload_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "AssayDownload"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.AssayDownload_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"AssayKey"), aname="_AssayKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","AssayFormatType",lazy=False)(pname=(ns,"AssayFormat"), aname="_AssayFormat", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","CompressType",lazy=False)(pname=(ns,"eCompress"), aname="_eCompress", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","AssayDownload")
            kw["aname"] = "_AssayDownload"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._AssayKey = None
                    self._AssayFormat = None
                    self._eCompress = None
                    return
            Holder.__name__ = "AssayDownload_Holder"
            self.pyclass = Holder

    class AssayDownloadResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "AssayDownloadResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.AssayDownloadResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"DownloadKey"), aname="_DownloadKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","AssayDownloadResponse")
            kw["aname"] = "_AssayDownloadResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._DownloadKey = None
                    return
            Holder.__name__ = "AssayDownloadResponse_Holder"
            self.pyclass = Holder

    class ScoreMatrix_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "ScoreMatrix"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.ScoreMatrix_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"ListKey"), aname="_ListKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname=(ns,"SecondaryListKey"), aname="_SecondaryListKey", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","ScoreTypeType",lazy=False)(pname=(ns,"ScoreType"), aname="_ScoreType", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","MatrixFormatType",lazy=False)(pname=(ns,"MatrixFormat"), aname="_MatrixFormat", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), GTD("http://pubchem.ncbi.nlm.nih.gov/","CompressType",lazy=False)(pname=(ns,"eCompress"), aname="_eCompress", minOccurs=0, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","ScoreMatrix")
            kw["aname"] = "_ScoreMatrix"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._ListKey = None
                    self._SecondaryListKey = None
                    self._ScoreType = None
                    self._MatrixFormat = None
                    self._eCompress = None
                    return
            Holder.__name__ = "ScoreMatrix_Holder"
            self.pyclass = Holder

    class ScoreMatrixResponse_Dec(ZSI.TCcompound.ComplexType, ElementDeclaration):
        literal = "ScoreMatrixResponse"
        schema = "http://pubchem.ncbi.nlm.nih.gov/"
        def __init__(self, **kw):
            ns = ns0.ScoreMatrixResponse_Dec.schema
            TClist = [ZSI.TC.String(pname=(ns,"DownloadKey"), aname="_DownloadKey", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            kw["pname"] = ("http://pubchem.ncbi.nlm.nih.gov/","ScoreMatrixResponse")
            kw["aname"] = "_ScoreMatrixResponse"
            self.attribute_typecode_dict = {}
            ZSI.TCcompound.ComplexType.__init__(self,None,TClist,inorder=0,**kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._DownloadKey = None
                    return
            Holder.__name__ = "ScoreMatrixResponse_Holder"
            self.pyclass = Holder

# end class ns0 (tns: http://pubchem.ncbi.nlm.nih.gov/)
