#$Id: analyzePage.py 91 2011-02-07 23:01:27Z sarkiss $
"""AnalyzePage.py contains the following classes.
"""
import wx, os, sys
from wx.lib.buttons import ThemedGenBitmapTextButton
from time import strftime
from AutoDockTools.Docking import Docking
from wxMainFrame import globalFolder
from icons import table_savePNG, database_savePNG
ID_SAVE_CSV = wx.NewId()
ID_SAVE_SDF = wx.NewId()
import enthought
import pybel, openbabel
from traitedBabel import openbabelAutoDockParameters
class Analyze(wx.Panel):
    def __init__(self, parent):
        wx.Panel.__init__(self, parent, -1)
        mainSizer = wx.BoxSizer()
        conformations = Conformations()
        self.conformations = conformations
        self.dockings = {}
        self.conformation = None
        view = conformations.View(self)
        grid = view.ui(conformations, self, kind='subpanel')
        self.grid = grid
        
        self.Bind(wx.EVT_SHOW, self.SetActive)
        self.frame = self.TopLevelParent
        #conformations.table_editor.editable = False
        #remove sizer. See enthought/traits/ui/wx/table_editor.TableEditor._create_toolbar
        #grid.control.Children[0].Children[0].Sizer.Children[0].GetSizer().Remove(0)

        #this part is needed to add tooltip
        if sys.version_info[0] == 2 and sys.version_info[1] == 5:
            self.wxgrid = grid.control.Children[0].Children[0].Children[4]    
        else:
            self.wxgrid = grid.control.Children[0].Children[0].Children[2]
        self.wxgrid.SetMinSize((0,0))

        wx.EVT_MOTION(self.wxgrid.Children[1], self.OnMouseMotion)    
        self.wxgrid.Bind(wx.grid.EVT_GRID_LABEL_LEFT_CLICK, self._on_label_left_click)        
        self.prev_col = None
        self.editor = grid._editors[0]
        self.editor.toolbar.control.AddLabelTool(ID_SAVE_CSV, "ID_SAVE_CSV", table_savePNG, shortHelp="Save as Comma-Separated Values (CSV)")
        self.Bind(wx.EVT_TOOL, self.OnSaveCSV, id=ID_SAVE_CSV)
        self.editor.toolbar.control.AddLabelTool(ID_SAVE_SDF, "Save as SDF", database_savePNG, shortHelp="Save as SDF (Structure Data Format).\nStores structures and Binding Affinity.")
        self.Bind(wx.EVT_TOOL, self.OnSaveSDF, id=ID_SAVE_SDF)
        
        self.wxgrid.Bind(wx.grid.EVT_GRID_CELL_RIGHT_CLICK, self.OnRightUp)
        mainSizer.Add(grid.control, 1, wx.EXPAND)
        self.SetSizer(mainSizer)
        mainSizer.SetSizeHints(self)
        self.editor.toolbar.control.Realize()
        self.list = []
        
    def _on_label_left_click(self, evt):
        row, col = evt.GetRow(), evt.GetCol()
        # A row value of -1 means this click happened on a column.
        # vice versa, a col value of -1 means a row click.
        if row == -1:
            self.grid._editors[0].grid._column_sort( col )
            
    def AddDocking(self, filename, updateTable=True):
        docking = Docking()
        docking.readDlg(filename)                
        if not docking.ch.conformations:
            self.frame.log.error("No docked conformation found in "+filename+"\n Please open that dlg file with a text editor to find out why.")
            return
        name =  os.path.splitext(os.path.split(filename)[1])[0]
        molName = docking.ligMol.name = os.path.split(docking.ligMol.name)[1]
        #self.frame.molNav.AddMolecule(docking.ligMol, resetCamera=False)
        targetName = os.path.splitext(os.path.split(docking.dlo_list[0].macroFile)[1])[0]
        self.dockings[name] = docking
        
        if name in self.frame.molNav.moleculesNames:
            index = self.frame.molNav.moleculesNames.index(name)
            self.frame.molNav.Remove(index)
    
        tmpList = []#without tmpList self.conformations update takes too long
        binding_energy = sys.maxint
        for index, conformation in enumerate(docking.ch.conformations):
            conf = Conformation(name = name, 
      #                          ki = conformation.inhib_constant,
                                intermol_energy = conformation.intermol_energy,
                                internal_energy = conformation.total_internal,
                                torsional_energy = conformation.torsional_energy,
                                binding_energy = conformation.binding_energy,
                                unbound_energy = conformation.unbound_energy,
                                index = index
                                )
            if conformation.binding_energy < binding_energy:
                binding_energy = conformation.binding_energy
                unbound_energy = conformation.unbound_energy
            tmpList.append(conf)
        if updateTable:
            self.conformations.items.extend(tmpList)
        else:
            self.list.extend(tmpList)
        args = (molName, targetName, binding_energy, unbound_energy,
                strftime("%Y.%m.%d %H:%M:%S"), "Autodock "+str(docking.version))
        if not hasattr(self.frame.dbView, 'resultsTable'):
            self.frame.dbView.Activate(None, showProgress=False)                
        self.frame.dbView.resultsTable.AddItem(args)
        return True 
        #self.frame.view.SetSelection(self.frame.view.GetPageIndex(self.frame.canvas3D))
         
    def SetActive(self, event):
        "This method is bound to wx.EVT_SHOW, i.e., invoked when this page is shown"    
        if self.frame.statusBar:
            self.frame.statusBar.SetStatusText('', 0)
        #self.grid.control.Children[0].Children[0].Children[0].SetPosition((0,0))        

    def OnSelect(self, conformation):
        "Updates conformation of the ligand"
        if not conformation:
            return
        else:
            self.conformation = conformation
        name = conformation.name
        if name in self.frame.molNav.moleculesNames:
            self.frame.molNav.UpdateConformation(self.dockings[name].ligMol, self.dockings[name].ch.conformations[conformation.index])
        else:
            molecule = self.dockings[name].ligMol
            aName = molecule.name
            molecule.name = name
            molecule.buildBondsByDistance()
            #self.frame.molNav.AddBonds(molecule, aName, force=True)                
            self.frame.molNav.ext = 'PDBQT'
            self.frame.molNav.AddMolecule(molecule, resetCamera=False)
            self.conformation = conformation
            self.frame.molNav.UpdateConformation(self.dockings[name].ligMol, self.dockings[name].ch.conformations[conformation.index])            
            self.frame.view.SetSelection(self.frame.view.GetPageIndex(self.frame.canvas3D))
            self.wxgrid.SetFocus() #otherwise can't scroll pass next molecule using down arrow on keyboard.

    def Clear(self, event=None):
        self.conformations.items = []
        self.dockings = {}
    
    def OnMouseMotion(self, event):
        "Modified from http://wiki.wxpython.org/wxGrid_ToolTips"
        x, y = self.wxgrid.CalcUnscrolledPosition(event.GetPosition())
        col = self.wxgrid.XToCol(x)
        if col != self.prev_col and col >= 0:
            self.prev_col = col
            hinttext = ''
            if col == 1:
                hinttext = 'Estimated Free Energy of Binding'
            elif col == 2:
                hinttext = 'Final Intermolecular Energy = vdW + Hbond + desolv Energy + Electrostatic Energy '
            elif col == 3:
                hinttext = 'Final Total Internal Energy'
            elif col == 4:
                hinttext = 'Torsional Free Energy'
            elif col == 4:
                hinttext = "Unbound System's Energy"
            self.wxgrid.Children[1].SetToolTipString(hinttext)
        event.Skip()

    def OnRightUp(self, event):       
        self.editor.set_selection(self.conformations.items[event.Row])     
        menu = wx.Menu()
        showHistogramMenu = menu.Append(wx.ID_ANY, "Create Clustering Histogram")
        self.Bind(wx.EVT_MENU, self.showHistogram, showHistogramMenu)
        menu.AppendSeparator()        
        DelMenu = menu.Append(wx.ID_ANY, "Delete All")
        self.Bind(wx.EVT_MENU, self.Clear,  DelMenu)
        self.PopupMenu(menu)
            
    def showHistogram(self, event):
        docking = self.dockings[self.editor.selected_row.name]
        try:
            rms = docking.clusterer.clustering_dict.keys()[0]
        except Exception, inst:
            self.frame.log.error("Error in showHistogram:\n"+str(inst))
        clusters = docking.clusterer.clustering_dict[rms]
        x = []
        y = []
        for item in clusters:
            energy = item[0].binding_energy
            x.append(energy)
            y.append(len(item))
        titleTxt = "Clustering (rms = "+str(rms)+")"
        width = 0.05
        if len(x) > 1:
            width = (x[1] - x[0])/10.
            if width < 0.05:
                width = 0.05

        page = self.frame.matplot.add(self.conformation.name)
        axes = page.figure.gca()            
        axes.bar(x,y, width=width, picker=True)
        axes.set_title(titleTxt)
        axes.set_ylabel("Conformations")
        axes.set_xlabel("Energy")
        self.frame.view.SetSelection(self.frame.view.GetPageIndex(self.frame.matplot))
        if self.frame.matplot.firstPlot:
            self.frame.matplot.nb.DeletePage(0)
            index = self.frame.view.GetPageIndex(self.frame.matplot)
            self.frame.view.Split(index,1)
            self.frame.matplot.firstPlot = False
        page.canvas.mpl_connect('pick_event', self.OnPick)
        page.canvas.clusters = clusters
        
    def OnPick(self, event):
        energy = event.artist.get_x()
        clusters = event.canvas.clusters
        name = clusters[0][0].mol.name
        selectedCluster = None
        for cluster in clusters:
            if cluster[0].binding_energy == energy:
                selectedCluster = cluster
        for item in self.conformations.items:
            if item.name == name and item.binding_energy == selectedCluster[0].binding_energy:
                selectConformation = item
                break
        self.editor.set_selection(selectConformation)
        index = self.conformations.items.index(selectConformation)
        self.wxgrid.MakeCellVisible(index, 0)
        
    def OnSaveCSV(self, event):
        dlg = wx.FileDialog(self, "Save as CVS", os.getcwd(), "", 
                            "Comma Separated Values (*.csv)|*.csv", 
                            style=wx.SAVE)
        if dlg.ShowModal() == wx.ID_OK:
            fileName = dlg.GetPath()
            if fileName[-3:].lower() != 'csv':
                fileName = fileName +".csv"            
            if os.path.exists(fileName):
                dlg1 = wx.MessageDialog(self, fileName +" already exists. Overwrite File?",
                                       'Overwrite File?',
                                       wx.YES_NO | wx.ICON_INFORMATION
                                       )
                if dlg1.ShowModal() != wx.ID_YES:
                    dlg1.Destroy()              
                    dlg.Destroy()
                    return  
            outFile = open(fileName, 'w')
            outFile.write('Ligand,Binding Energy,Intermol Energy,Internal Energy,Torsional Energy,Unbound Energy\n')                   
            for item in self.conformations.items:
                txt = item.name +","+str(item.binding_energy)+","+str(item.intermol_energy)+","+str(item.internal_energy)+\
                                ","+str(item.torsional_energy)+","+str(item.unbound_energy)
                outFile.write(txt+"\n")
            outFile.close()       
        dlg.Destroy()   

    def OnSaveSDF(self, event):
        if not self.conformations.items:        
            dlg = wx.MessageDialog(self, 'Results table is empty. Please insert new items.',
                                   'A Message Box',
                                   wx.OK | wx.ICON_INFORMATION
                                   )
            dlg.ShowModal()
            dlg.Destroy()   
            return         
        global globalFolder            
        dlg = wx.FileDialog(self, "Save as SDF", globalFolder, "", 
                            "Structure Data Format (*.sdf)|*.sdf", 
                            style=wx.SAVE)
        if dlg.ShowModal() == wx.ID_OK:
            fileName = dlg.GetPath()
            if fileName[-3:].lower() != 'sdf':
                fileName = fileName +".sdf"
            if os.path.exists(fileName):
                dlg1 = wx.MessageDialog(self, fileName +" already exists. Overwrite File?",
                                       'Overwrite File?',
                                       wx.YES_NO | wx.ICON_INFORMATION
                                       )
                if dlg1.ShowModal() != wx.ID_YES:
                    dlg1.Destroy()              
                    dlg.Destroy()
                    return         
            globalFolder = os.path.split(fileName)[0]
            outputfile = pybel.Outputfile("sdf",  str(fileName), overwrite=True)     
            if openbabelAutoDockParameters.numberOfPoses == 0:
                for item in self.conformations.items:
                    self.dockings[item.name].ch.conformations[item.index].coords
                    mol = self.frame.openBabel.ConvertToOB_withCoords(self.dockings[item.name].ligMol, 
                                                                      self.dockings[item.name].ch.conformations[item.index].coords)
                    pairdata = openbabel.OBPairData()
                    pairdata.SetAttribute("Binding_Energy")
                    pairdata.SetValue(str(item.binding_energy))                
                    mol.CloneData(pairdata)       
                    mol.SetTitle(str(item.name+"_"+str(item.index)))
                    outputfile.write(pybel.Molecule(mol))
            else:
                self.conformations.items.sort(key=lambda x: x.binding_energy)
                for item in self.conformations.items[0:openbabelAutoDockParameters.numberOfPoses]:            
                    self.dockings[item.name].ch.conformations[item.index].coords
                    mol = self.frame.openBabel.ConvertToOB_withCoords(self.dockings[item.name].ligMol, 
                                                                      self.dockings[item.name].ch.conformations[item.index].coords)
                    pairdata = openbabel.OBPairData()
                    pairdata.SetAttribute("Binding_Energy")
                    pairdata.SetValue(str(item.binding_energy))                
                    mol.CloneData(pairdata)       
                    mol.SetTitle(str(item.name+"_"+str(item.index)))
                    outputfile.write(pybel.Molecule(mol))
            outputfile.close()
        dlg.Destroy()   

    def Open(self, event=None):
        global globalFolder            
        dlg = wx.FileDialog(self, "Choose Docking Log File", globalFolder, '',
                            "Docking Log File (*.dlg)|*.dlg", wx.OPEN)        
        if dlg.ShowModal() == wx.ID_OK:     
            filename = dlg.GetPath()  
            
            test = self.frame.TryCommand(self.AddDocking, filename)
            globalFolder = os.path.split(filename)[0]
        dlg.Destroy()
        if test:            
            self.frame.controls.SetSelection(self.frame.controls.GetPageIndex(self.frame.autodockWiz))
            self.frame.autodockWiz.book.Selection = 4
         
from enthought.traits.ui.api import View, Group, Item, TableEditor
from enthought.traits.api import HasTraits, HasStrictTraits, Str, Int, Float, List
from enthought.traits.ui.table_column import ObjectColumn
from enthought.traits.ui.table_filter import EvalFilterTemplate, MenuFilterTemplate, \
                                             RuleFilterTemplate, RuleTableFilter, MenuTableFilter
class Conformation(HasTraits):
    name = Str
    binding_energy = Float
    #ki = Float
    intermol_energy = Float
    internal_energy = Float
    torsional_energy = Float
    docking_energy = float
    unbound_energy = float
    index = Int #this index to becouse multiple dockings can be merged in single Conformations
    
class Conformations(HasTraits):
    items = List(Conformation)

    def View(self, parent):
        "on_add_new is called to add new element"

        def my_row_factory(**kw):
            parent.Open()
            return None
            
        FilterTemplate = MenuTableFilter(name='No filter', template=True,)  
        table_editor = TableEditor(
            columns = [ ObjectColumn(name='name', editable = False, label='Ligand'),
     #                   ObjectColumn(name='ki', label='Ki (mM)'),
                        ObjectColumn(name='binding_energy', label='Binding Energy (kcal/mol)=(1)+(2)+(3)-(4)', editable = False),
                        ObjectColumn(name='intermol_energy', label='(1) Intermol Energy', editable = False),
                        ObjectColumn(name='internal_energy', label='(2) Internal Energy', editable = False),
                        ObjectColumn(name='torsional_energy', label=' (3) Torsional Energy', editable = False),
                        ObjectColumn(name='unbound_energy', label=' (4) Unbound Energy', editable = False),
                        ],                                      
            reorderable = False,
            sort_model  = True,    
            auto_size = False,
            on_select = parent.OnSelect,
            editable = True,
            show_toolbar = True,
            row_factory = my_row_factory,
            filters     = [FilterTemplate] ,
            deletable = True,
        )
        self.table_editor = table_editor
        return View(
                    Group( Item( 'items',
                            show_label  = False,
                            editor      = table_editor
                                ),  
                         )
                    )
