#$Id: miscTraits.py 91 2011-02-07 23:01:27Z sarkiss $
from enthought.traits.api import HasTraits, List, Trait, Int, Bool, Float, Enum, File, Str, TraitHandler
from enthought.traits.ui.api import Item, Group, View, CheckListEditor, VGroup, HGroup, spring, EnumEditor
class TraitPositiveInteger(TraitHandler):
    def validate(self, object, name, value):
        try:
            value = int(value)
            if value > 0:
                return value
        except:
            pass
        self.error(object, name, value)
        
    def info(self):
        return 'a positive integer'

def PositiveInt(value = 1):
    return Trait( value, TraitPositiveInteger(), Int )

class TraitPositiveFloat(TraitHandler):
    def validate(self, object, name, value):
        try:
            value = float(value)
            if value > 0:
                return value
        except:
            pass
        self.error(object, name, value)
        
    def info(self):
        return 'a positive float'

def PositiveFloat(value = 1):
    return Trait( value, TraitPositiveInteger(), Float )
