#$Id: pbsJobs.py 91 2011-02-07 23:01:27Z sarkiss $

import  wx
import time, os, sys, subprocess
import utils
from vsModel import autodockPreferencesPage, autodockRemotePreferencesPage 
def startAutogrid(parent):
        cmdTxt = ' '.join(parent.vsModel.gridCommand)
        cmdTxt = cmdTxt.replace(autodockPreferencesPage.autogrid, utils.which(autodockPreferencesPage.autogrid))
        cwdTxt = parent.vsModel.receptorFolder #current working directory
        rJob = os.path.join(cwdTxt, "PyRxAutoGridJob")
        oFile = open(rJob,'w')
        oFile.write("cd "+cwdTxt+"\n")
        oFile.write(cmdTxt)    
        oFile.close()
        os.system("chmod +x "+ rJob)
        id = subprocess.Popen("qsub -V -l cput=23:00:00 -l nodes=1:ppn=1 " + rJob , shell=True, stdout=subprocess.PIPE).stdout.read()
        readme = os.path.join(cwdTxt, "README")
        oFile = open(readme, 'w')
        oFile.write("Submitted AutoGrid job :  qsub -l cput=23:00:00 -l nodes=1:ppn=1 PyRxAutoGridJob\n")
        oFile.write("Output: "+id)
        oFile.write("\n\nPlease wait for this job to finish before starting AutoDock.")
        oFile.write("\n\nRun 'qstat "+id.split('.')[0]+"' from a command line to see the status of this job.")
        oFile.write("\nRun 'qdel "+id.split('.')[0]+"' to delete this pbs job.")
        oFile.close()
        parent.TopLevelParent.documentsView.ClosePath(readme)
        parent.TopLevelParent.documentsView.OpenDocument(readme)
        
def startAutodock(parent):
    readme = os.path.join(parent.vsModel.receptorFolder, "README")
    open(readme, 'w')
    parent.TopLevelParent.documentsView.ClosePath(readme) 
    doc = parent.TopLevelParent.documentsView.OpenDocument(readme)
    txtCtrl = doc.GetFirstView().GetTextCtrl()
    txtCtrl.AppendText("Creating AutoDock jobs with the following ID's:\n")
    parent.Update()
    maximum =  len(parent.ligands)
    dlg = wx.ProgressDialog("AutoDock Job Submission Progress",
                           "AutoDock  Job Submission in Progress. Please Wait...",
                           maximum = len(parent.ligands),
                           parent = parent,
                           style = wx.PD_CAN_ABORT
                            | wx.PD_APP_MODAL
                            | wx.PD_ELAPSED_TIME
                            | wx.PD_REMAINING_TIME
                            )        
    for index, ligand in enumerate(parent.ligands):
        (keepGoing, skip) = dlg.Update(index, "Submitting  "+ligand+" ("+str(index+1) +" of " +str(maximum)+")")
        if not keepGoing:
            break
        parent.vsModel.PrepareDPF(parent.vsModel.molDict[ligand], parent.docking_algorithm_parameter_list)  
        rJob = os.path.join(parent.vsModel.dockingFolder, "PyRxAutoDockJob")
        oFile = open(rJob,'w')
        cmdStr = ' '.join(parent.vsModel.dockCommand)
        cmdStr = cmdStr.replace(autodockPreferencesPage.autodock, utils.which(autodockPreferencesPage.autodock))
        oFile.write("cd "+parent.vsModel.dockingFolder+"\n")
        oFile.write(cmdStr)    
        oFile.close()
        os.system("chmod +x "+ rJob)
        id = subprocess.Popen("qsub -V -l cput=23:00:00 -l nodes=1:ppn=1 " + rJob , shell=True, stdout=subprocess.PIPE).stdout.read()
        txtCtrl.AppendText(id)
        txtCtrl.ScrollToEnd()
        parent.Update()
    dlg.Destroy()        
    txtCtrl.AppendText("Done\n\n\nPlease wait to these jobs to finish to analyze the results.\nRun `qstat` from a command line to show status of pbs batch jobs")
    doc.Save()

def startVina(parent):
    readme = os.path.join(parent.basePath, "README")
    open(readme, 'w')
    parent.TopLevelParent.documentsView.ClosePath(readme) 
    doc = parent.TopLevelParent.documentsView.OpenDocument(readme)
    txtCtrl = doc.GetFirstView().GetTextCtrl()
    txtCtrl.AppendText("Creating Vina jobs with the following ID's:\n")
    parent.Update()
    maximum =  len(parent.ligands)
    dlg = wx.ProgressDialog("Vina Job Submission Progress",
                           "Vina  Job Submission in Progress. Please Wait...",
                           maximum = len(parent.ligands),
                           parent = parent,
                           style = wx.PD_CAN_ABORT
                            | wx.PD_APP_MODAL
                            | wx.PD_ELAPSED_TIME
                            | wx.PD_REMAINING_TIME
                            )        
    for index, ligand in enumerate(parent.ligands):
        (keepGoing, skip) = dlg.Update(index, "Submitting  "+ligand+" ("+str(index+1) +" of " +str(maximum)+")")
        if not keepGoing:
            break

        ligandFolder = os.pardir+os.sep+os.pardir+os.path.sep+"Ligands"         
        outputFile = ligand+"_out.pdbqt"
        rJob = os.path.join(parent.basePath, "PyRxVinaJob-"+ligand)
        oFile = open(rJob,'w')
        oFile.write("cd "+parent.basePath+"\n")
        vina = utils.which(autodockPreferencesPage.vina)
        cmdStr = vina+ " --config conf.txt --cpu 1 --ligand " +ligandFolder+os.path.sep+ligand+".pdbqt" + ' --out '+outputFile

        oFile.write(cmdStr)    
        oFile.close()
        os.system("chmod +x "+ rJob)
        id = subprocess.Popen("qsub  -l cput=00:30:00 -l nodes=1:ppn=1 -l walltime=00:30:00 -l mem=512mb " + rJob , shell=True, stdout=subprocess.PIPE).stdout.read()
        txtCtrl.AppendText(id)
        txtCtrl.ScrollToEnd()
        parent.Update()
    dlg.Destroy()        
    txtCtrl.AppendText("Done\n\n\nPlease wait to these jobs to finish to analyze the results.\nRun `qstat` from a command line to show status of pbs batch jobs")
    doc.Save()
