#$Id: preferences.py 91 2011-02-07 23:01:27Z sarkiss $
"""Preferences.py is used for Edit --> Preferences dialog
"""
import  wx
import  wx.lib.filebrowsebutton as filebrowse
import pickle, os

from enthought.traits.api import Color, Int, Float, Str, Bool
from enthought.traits.ui.api import View, Group, Item, Label
from enthought.preferences.api import Preferences, PreferencesHelper
from enthought.preferences.api import get_default_preferences
from enthought.preferences.api import set_default_preferences
from enthought.preferences.ui.api import PreferencesManager, PreferencesPage

from utils import rcFile, cpuCount, which

global_preferences = Preferences(filename=rcFile)
set_default_preferences(global_preferences)
    
from vsModel import autodockPreferencesPage, ligandPreparationPage, autodockRemotePreferencesPage
from traitedBabel import openbabelParameters, openbabelAutoDockParameters

pages=[
    autodockPreferencesPage,
    ligandPreparationPage,
    autodockRemotePreferencesPage,
    openbabelParameters,
    openbabelAutoDockParameters,
    ]
import enthought
        
if enthought.traits.version.__version__ > "3.1":
    from logger import logger_preferences
    pages.append(logger_preferences)
          
preferences_manager = PreferencesManager(pages=pages)

def setGlobalPreferences():
    set_default_preferences(global_preferences)