#!/usr/bin/python
#$Id: runPyRx.py 96 2011-02-14 19:15:41Z sarkiss $
"""
This script starts PyRx
"""
import sys, os, pdb, user, subprocess
resourceFolder = os.path.join(user.home, ".mgltools", "PyRx")
updateFolder = os.path.join(resourceFolder, 'update')
import wx
stderr = sys.stderr

def startPyRx(updateFolder=None):
    "This function initializes PyRx. If updateFolder is provided do sys.path.insert(0, updateFolder)"
    if updateFolder:
        sys.path.insert(0, updateFolder)
    redirect = True #change this to True to get error messages to popup
    try:
        from PyRx.wxMainFrame import MainFrame 
    except Exception, inst:
        print inst
        sys.path.append(os.path.split(__file__)[0])
        from PyRx.wxMainFrame import MainFrame 
    from enthought.pyface.api import GUI,  ImageResource, SplashScreen
    import PyRx
    imagePath = os.path.join(PyRx.__path__[0],'Images','PyRx_splash.jpg')
    splash_screen = SplashScreen(image=ImageResource(imagePath))
    gui = GUI(splash_screen=splash_screen)    
    #from PyRx.utils import rcFolder
    app = wx.App(redirect=redirect)#, filename = os.path.join(rcFolder,"PyRx.log"))
    app.SetAppName("PyRx")
    
    size = wx.GetDisplaySize()
    height = size.GetHeight()
    width = size.GetWidth()
    if width > 1200: #to avoid spanning multiple displays
        width = 1200
    
    frame = MainFrame(None, -1, size=(width, height-200))
    gui.process_events()
    frame.Show()
    globals()['frame'] = frame #this is needed to make frame available from Python Shell
    gui.start_event_loop()

if os.path.exists(updateFolder):
    try:
        startPyRx(updateFolder)
    except Exception, e:
        import traceback
        sys.stderr = stderr
        stderr.write(str(traceback.print_exc())+"\n")
        stderr.write("Problem starting updated PyRx. Removing updates and restarting PyRx...\n")
        executable = sys.executable
        if os.name == 'nt':
            executable = executable.replace("\\","""\\\\""")                  
        script = __file__
        
        if os.name == 'nt':
            executable = executable.replace("\\","""\\\\""")                  
            script = script.replace("\\","""\\\\""")                  
        
        executable = '"'+executable+'"'
        script = '"'+script+'"'
    
        txt = """
import time,os,shutil,subprocess
time.sleep(1)
def onerror(func, path, exc_info):
    import stat
    if not os.access(path, os.W_OK):
        # Is the error an access error ?
        os.chmod(path, stat.S_IWUSR)
        func(path)
    else:
        raise
shutil.rmtree("%s", onerror=onerror);
subprocess.call([%s,%s])
"""%(updateFolder, executable, script)
        updatePy = os.path.join(resourceFolder, 'update.py')
        open(updatePy,'w').write(txt)
        cmd = executable +" " +updatePy
        if os.name == 'nt':                  
            cmd = cmd.encode()
        else:
            cmd += ' &'
        subprocess.Popen(cmd, shell=True)
        os._exit(0)
else:
    try:
        startPyRx()
    except Exception, e:
        import traceback
        type, value, stack = sys.exc_info()
        backtrace = traceback.format_exception(type, value, stack)
        sys.stderr = stderr
        msg = "".join(backtrace)
        msg += "\nProblem starting PyRx. Please visit PyRx forum for a possible solution: http://mgl.scripps.edu/forum"
        import  wx.lib.dialogs
        dlg = wx.lib.dialogs.ScrolledMessageDialog(None, msg, "Error starting PyRx")
        dlg.ShowModal()