#$Id: autogridPage.py 265 2016-02-14 20:36:28Z sarkiss $
"""AutoGridPage.py contains the following classes.
"""
import wx, os, glob
from wx.lib.buttons import ThemedGenBitmapTextButton
from enthought import tvtk
import runProcess
import utils
from AutoDockTools.GridParameters import GridParameters
from vsModel import autodockPreferencesPage, autodockRemotePreferencesPage 
from time import strftime
scale_factor = 1.3 #used to scale the search box

class RunAutoGrid(wx.Panel):
    def __init__(self, parent):
        self.flagRunAutoGrid = False
        wx.Panel.__init__(self, parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)
        topSizer = wx.BoxSizer(wx.HORIZONTAL)
        listBoxSizer = wx.BoxSizer(wx.VERTICAL)
        listBoxSizer.Add(wx.StaticText(self, -1, "AutoDock Elements:"), 0, wx.LEFT, 10)
        self.listBox = wx.ListBox(self, style=wx.BORDER_SUNKEN)
        listBoxSizer.Add(self.listBox, 1, wx.EXPAND)
        topSizer.Add(listBoxSizer, 1, wx.EXPAND)
        listBoxSizer = wx.BoxSizer(wx.VERTICAL)
        #listBoxSizer.Add(wx.StaticText(self, -1, "Grid Parameters:"), 0, 5, wx.ALL)        
        from boxUI import AutoGirdBoxUI
        boxWidget = AutoGirdBoxUI()
#        grid = GridUI()
#        self.grid = grid
        view = boxWidget.View()
        boxUI = view.ui(boxWidget, self, kind='subpanel')
        self.comboBox = wx.ComboBox(self, id=wx.ID_ANY, style=wx.CB_READONLY)
        listBoxSizer.Add(self.comboBox, 0, wx.EXPAND)        
        listBoxSizer.Add(boxUI.control, 1, wx.EXPAND)        
        topSizer.Add(listBoxSizer, 1, wx.EXPAND)
        sizer.Add(topSizer, 1, wx.EXPAND, wx.ALIGN_BOTTOM)
        
        self.forwardButton = wx.Button(self, wx.ID_FORWARD, "")
        self.backButton = wx.Button(self, wx.ID_BACKWARD, "") 
        bitmap = wx.ArtProvider_GetBitmap(wx.ART_EXECUTABLE_FILE, wx.ART_BUTTON)
        runAutoGridButton = ThemedGenBitmapTextButton(self, -1, bitmap, "Run AutoGrid")
        buttonSizer = wx.BoxSizer(wx.HORIZONTAL)
       
        lin = wx.StaticLine(self)
        buttonSizer.Add(runAutoGridButton, 0)
        
        buttonSizer.Add((150, -1), 1, flag=wx.EXPAND | wx.ALIGN_RIGHT)
        buttonSizer.Add(self.backButton, 0, wx.ALIGN_RIGHT)
        buttonSizer.Add(self.forwardButton, 0, wx.ALIGN_RIGHT)
        
        sizer.Add(lin,0,wx.EXPAND)
        sizer.Add(buttonSizer, 0, wx.EXPAND|wx.ALIGN_BOTTOM)
        self.SetSizer(sizer)
        self.Bind(wx.EVT_BUTTON, self.Next, self.forwardButton)
        self.Bind(wx.EVT_BUTTON, self.Back, self.backButton)
        self.Bind(wx.EVT_BUTTON, self.Run, runAutoGridButton)
        self.Bind(wx.EVT_COMBOBOX, self.OnMacromoleculeChanged, self.comboBox)        
        #self.Bind(wx.EVT_SHOW, self.SetActive)
        self.frame = self.TopLevelParent
        self.vsModel = self.frame.vsModel       

        boxWidget.set(interactor=self.frame.mayaviEngine.scene.interactor)
        boxWidget.set(place_factor=1)
        boxWidget.rotation_enabled = False
        boxWidget.key_press_activation = False
        boxWidget.add_observer("InteractionEvent", boxWidget.ChangeBox)
        self.boxWidget = boxWidget
        
    def SetActive(self, event):
        "This method is bound to wx.EVT_SHOW, i.e., invoked when this page is shown"
        #check if ligand_types are set
        if not self.frame.autodockWiz.selectMoleculesPage.ligandPass or not hasattr(self.vsModel,'ligands'):
            self.frame.autodockWiz.selectMoleculesPage.Next(None)
            dlg = wx.MessageDialog(self, "Please select a ligand!",'A Message Box',
                                   wx.OK| wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()            
            wx.CallAfter(self.Parent.SetSelection, 1)            
            return
        #check if macromoleculePath is set
        if not self.frame.autodockWiz.selectMoleculesPage.macromoleculePass:
            dlg = wx.MessageDialog(self, "Please select macromolecule!",'A Message Box',
                                   wx.OK| wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()            
            wx.CallAfter(self.Parent.SetSelection, 2)
            return
        self.comboBox.Clear() #clears drop-down menu
        self.flagRunAutoGrid = False        
        macromoleculePaths = self.frame.autodockWiz.selectMoleculesPage.macromoleculePaths
        self.macromolecules = []
        for macromoleculePath in macromoleculePaths:                    
            tmp, ext = os.path.splitext(macromoleculePath)
            basePath, molName = os.path.split(tmp)
            
            if not molName in self.frame.molNav.moleculesNames:
                macromolecule = self.frame.molNav.TryOpenMolecule(macromoleculePath)[0]
            else:
                index = self.frame.molNav.moleculesNames.index(molName)
                macromolecule = self.frame.molNav.molecules[index]
        
            self.macromolecules.append(macromolecule)
            
            macromolecule.receptorFolder = basePath
            macromolecule.receptor_filename = molName+ext
            macromolecule.receptor_filename = macromolecule.receptor_filename.encode()
            macromolecule.receptor_stem = molName.encode()

            flexPath = os.path.join(basePath, molName.replace("_rigid","")+"_flex.pdbqt")
            if os.path.exists(flexPath): #add flex residue atom types
                from AutoDockTools.atomTypeTools import AutoDock4_AtomTyper
                from MolKit.pdbParser import PdbqtParser
                parser = PdbqtParser(flexPath)
                molecules = parser.parse()
                ad4_typer = AutoDock4_AtomTyper()
                ad4_typer.setAutoDockElements(molecules[0])
                self.vsModel.ligand_types = self.vsModel.ligand_types.union(set(molecules[0].allAtoms.autodock_element))

            if not hasattr(macromolecule, 'AD_max_XDimension'): #AD_max_XDimensionr is an arbitrary attribute which is set below   
                center = macromolecule.getCenter()        
                macromolecule.box_center = center
                macromolecule.X_center, macromolecule.Y_center, macromolecule.Z_center = center
                macromolecule.initCenter = tuple(center)
                bounds = macromolecule.assembly.GetBounds()
                macromolecule.spacing = macromolecule.initSpacing = self.boxWidget.initSpacing
                macromolecule.AD_X_dimension = macromolecule.AD_max_XDimension = int(abs(bounds[1]-bounds[0])/self.boxWidget.initSpacing*scale_factor)
                macromolecule.AD_Y_dimension = macromolecule.AD_max_YDimension = int(abs(bounds[3]-bounds[2])/self.boxWidget.initSpacing*scale_factor)
                macromolecule.AD_Z_dimension = macromolecule.AD_max_ZDimension = int(abs(bounds[5]-bounds[4])/self.boxWidget.initSpacing*scale_factor)
                macromolecule.initDimension = (macromolecule.AD_X_dimension,macromolecule.AD_Y_dimension,macromolecule.AD_Z_dimension)
            self.comboBox.Append(macromolecule.name, macromolecule)
            #check if we have grid maps
            mapFiles = glob.glob(basePath+os.sep+'*.map')
            if mapFiles:
                if not self.vsModel.ligand_types: #not sure if this is needed?
                    self.vsModel.ligand_types = set(['A', 'C', 'HD', 'NA', 'OA', 'N'])
                for ligandType in self.vsModel.ligand_types:
                    str = os.path.join(basePath, molName+'.'+ligandType+'.map')
                    if not os.path.exists(str):
                        self.flagRunAutoGrid = True
                        break      
                gpf = os.path.join(basePath, molName+'.gpf')
                if os.path.exists(gpf):
                    #get box dimension from the previous run
                    gpm = GridParameters()
                    gpm.read4(os.path.join(basePath, molName+'.gpf'))
                    gridcenter = gpm.data['gridcenter']['value']
                    if  gridcenter != 'auto':
                        macromolecule.box_center = gridcenter
                        macromolecule.X_center, macromolecule.Y_center, macromolecule.Z_center = gridcenter
                    macromolecule.spacing = gpm.data['spacing']['value']
                    dim = gpm.data['npts']['value']
                    macromolecule.X_dimension = dim[0]
                    macromolecule.Y_dimension = dim[1]
                    macromolecule.Z_dimension = dim[2]
                else:
                    self.flagRunAutoGrid = True
            else:
                self.flagRunAutoGrid = True

        self.listBox.Set(list(self.vsModel.ligand_types))
        #activate 3D Graphics tab
        self.frame.view.SetSelection(self.frame.view.GetPageIndex(self.frame.canvas3D))            
        #select first macromolecule and setup boxWidget
        self.select_macromolecule = self.macromolecules[0]
        self.comboBox.SetValue(self.select_macromolecule.name)
        self.boxWidget.X_center = self.select_macromolecule.X_center
        self.boxWidget.Y_center = self.select_macromolecule.Y_center
        self.boxWidget.Z_center = self.select_macromolecule.Z_center
        self.boxWidget.X_dimension = self.select_macromolecule.AD_X_dimension
        self.boxWidget.Y_dimension = self.select_macromolecule.AD_Y_dimension
        self.boxWidget.Z_dimension = self.select_macromolecule.AD_Z_dimension
        self.boxWidget.max_XDimension = self.select_macromolecule.AD_max_XDimension
        self.boxWidget.max_YDimension = self.select_macromolecule.AD_max_YDimension
        self.boxWidget.max_ZDimension = self.select_macromolecule.AD_max_ZDimension
        self.boxWidget.initCenter = self.select_macromolecule.initCenter
        self.boxWidget.initDimension = self.select_macromolecule.initDimension
        self.boxWidget.spacing = self.select_macromolecule.spacing
        self.boxWidget.enabled = True  
        self.frame.canvas3D.Refresh()
          
    def OnMacromoleculeChanged(self, event):
        "Called when an item on the Macromolecule ComboBox list is selected"
        cb = event.GetEventObject()
        data = cb.GetClientData(event.GetSelection())
        self.UpdateMacromoleculeBox()
        #update boxWidget with settings from currenty selected macromolecule
        self.boxWidget.X_center = data.X_center
        self.boxWidget.Y_center = data.Y_center
        self.boxWidget.Z_center = data.Z_center
        self.boxWidget.X_dimension = data.AD_X_dimension
        self.boxWidget.Y_dimension = data.AD_Y_dimension
        self.boxWidget.Z_dimension = data.AD_Z_dimension
        self.boxWidget.initDimension = data.initDimension        
        self.boxWidget.spacing = data.spacing
        self.select_macromolecule = data                
        self.boxWidget.max_XDimension = self.select_macromolecule.AD_max_XDimension
        self.boxWidget.max_YDimension = self.select_macromolecule.AD_max_YDimension
        self.boxWidget.max_ZDimension = self.select_macromolecule.AD_max_ZDimension        
        self.boxWidget.initCenter = self.select_macromolecule.initCenter  
    
    def UpdateMacromoleculeBox(self):
        #copy current boxWidget's settings for previously selected macromolecule
        self.select_macromolecule.X_center = self.boxWidget.X_center
        self.select_macromolecule.Y_center = self.boxWidget.Y_center
        self.select_macromolecule.Z_center = self.boxWidget.Z_center
        self.select_macromolecule.AD_X_dimension = self.boxWidget.X_dimension
        self.select_macromolecule.AD_Y_dimension = self.boxWidget.Y_dimension
        self.select_macromolecule.AD_Z_dimension = self.boxWidget.Z_dimension
        
    def Next(self, event):
        "Goto next page"       
        self.UpdateMacromoleculeBox()    
        if self.flagRunAutoGrid:
            self.Run(None)     
        else:
            self.Parent.SetSelection(3)
        self.boxWidget.enabled = False
        
    def Back(self, event):
        "Goto previous page"
        self.Parent.SetSelection(1)
        self.boxWidget.enabled = False
    
    def Run(self, event):
        self.UpdateMacromoleculeBox()
        self.frame.TryCommand(self.TryRun, None)
        
    def TryRun(self, event):    
        self.macromolecules_count = len(self.macromolecules)
        for macromolecule in self.macromolecules:  
            gridParameters = {}
            gridParameters['npts'] = str(macromolecule.AD_X_dimension)+','
            gridParameters['npts'] += str(macromolecule.AD_Y_dimension)+','
            gridParameters['npts'] += str(macromolecule.AD_Z_dimension)
            gridParameters['gridcenter'] = [macromolecule.X_center, 
                                            macromolecule.Y_center, 
                                            macromolecule.Z_center]
            gridParameters['spacing'] = macromolecule.spacing
            executionMode = self.frame.autodockWiz.startPage.runAutoDockOptions[autodockPreferencesPage.executionMode]
            if not executionMode == "Remote (Opal Web Services)" and not utils.which(autodockPreferencesPage.autogrid):
                dlg = wx.MessageDialog(self, "Cannot find "+autodockPreferencesPage.autogrid+
                                       "\n\n. Use Edit -> Preferences to set AutoGrid path.",  'Command not found.',  wx.OK| wx.ICON_EXCLAMATION)
                dlg.ShowModal()
                dlg.Destroy()            
                return
            self.vsModel.macromolecule = macromolecule
            self.vsModel.PrepareGPF(gridParameters=gridParameters)
            autodock_elements = ""
            for item in list(self.vsModel.ligand_types):
                autodock_elements += str(item) +" "        
            args = (macromolecule.name, len(macromolecule.allAtoms), strftime("%Y.%m.%d %H:%M:%S"),autodock_elements)
            if not hasattr(self.frame.dbView, 'targetsTable'):
                self.frame.dbView.Activate(None)        
            self.frame.dbView.targetsTable.AddItem(args, deleteOnFirstMatch=True)
            if executionMode == "Remote (Opal Web Services)":
                self.processPanel = self.frame.autodockWS.GetAutogridWSPanel(self.GrandParent, self.CheckResults)
            else:
                if self.Parent.GetPage(0).rb.GetSelection() == 0:
                    if os.path.exists(self.vsModel.glgOutput):
                        os.remove(self.vsModel.glgOutput)
                    self.processPanel = runProcess.ProcessPanel(self.GrandParent, self.vsModel.gridCommand, 
                                                                macromolecule.receptorFolder, self.vsModel.glgOutput, self.CheckResults)
                else:
                    import pbsJobs
                    if not pbsJobs.startAutogrid(self):
                        return
                    if macromolecule == self.macromolecules[-1]:
                        return
                    else:
                        continue
            self.frame.view.AddPage(self.processPanel, "Run AutoGrid "+macromolecule.name, select=True)
            self.processPanel.Start()
        self.frame.statusBar.SetStatusText("Running AutoGrid. Please Wait...", 0)            
        self.frame.autodockWiz.book.Disable()
         
    def CheckResults(self, page, outputFile=None, success=False):
        self.frame.view.DeletePage(self.frame.view.GetPageIndex(page))        
        self.macromolecules_count -= 1        
        if success:
            documentsView = self.frame.documentsView 
            documentsView.ClosePath(outputFile) #to avoid "...has been modified outside of..." message from wx.lib.docview
            documentsView.OpenDocument(outputFile)
            textCtrl = documentsView._docManager.GetCurrentView()._textCtrl
            wx.CallAfter(textCtrl.ScrollToEnd)
            if textCtrl.GetText().find("Successful Completion") == -1:
                self.frame.statusBar.SetStatusText("Unsuccessful AutoGrid Completion. See Log File for Details. ", 0)
            else:
                self.frame.statusBar.SetStatusText("Successful AutoGrid Completion.", 0)
                if self.macromolecules_count < 1:
                    self.Parent.SetSelection(3)   
                    self.frame.autodockNav.RefreshMacroolecules()
                    self.boxWidget.enabled = False
                    self.frame.autodockWiz.book.Enable()
        else:
            self.frame.statusBar.SetStatusText("AutoGrid run terminated.", 0)                
            self.boxWidget.enabled = False
 