#$Id: gridConverter.py 91 2011-02-07 23:01:27Z sarkiss $
"""Converts all grids supported by Volume package from MGLTools to VTK XML format."""
from Volume.IO.volReaders import ReadMRC, ReadCCP4, ReadCNS, ReadGRD, ReadBRIX,\
                                    ReadSPIDER, ReadRawiv, ReadEM, ReadFLDBinary
from Volume.IO.volWriters import WriteCCP4
from Volume.IO.UHBDGridReader import UHBDReaderASCII
from Volume.IO.DelphiReader import DelphiReaderBin
from Volume.IO.dxReader import ReadDX
from Volume.IO.AutoGridReader import ReadAutoGrid
from Volume.IO.gamessOrbitalsReader import ReadGamessOrbitals

from enthought.tvtk.api import tvtk

import sys, re, os
import numpy

def convertToTVTK(gridFile):
    reader = None
    if not os.path.exists(gridFile):
        print gridFile, " not exists" 
    else:
        if(re.search('\.mrc$',gridFile,re.I)):
            reader = ReadMRC()
        elif(re.search('\.ccp4*$',gridFile,re.I)):
            reader = ReadCCP4()
        elif(re.search('\.cns$|\.xplo*r*$',gridFile,re.I)):
            reader = ReadCNS()
        elif(re.search('\.grd$',gridFile,re.I)):
            reader = ReadGRD()
        elif(re.search('\.fld$',gridFile,re.I)):
            reader = ReadFLDBinary()
        elif(re.search('\.map$',gridFile,re.I)):
            reader = ReadAutoGrid()
        elif(re.search('\.omap$|\.brix$|\.dsn6$|\.dn6$',gridFile,re.I)):
            reader = ReadBRIX()
        elif(re.search('\.rawiv$',gridFile,re.I)):
            reader = ReadRawiv()
        elif(re.search('\.d*e*l*phi$',gridFile,re.I)):
            reader = DelphiReaderBin()
        elif(re.search('\.uhbd$',gridFile,re.I)):
            reader = UHBDReaderASCII()
        elif(re.search('\.dx$',gridFile,re.I)):
            reader = ReadDX()
        elif(re.search('\.spi$',gridFile,re.I)):
            reader = ReadSPIDER()
    if not reader:
        print "Error: Unknown file format " + gridFile
        usage()
        
    grid3D = reader.read(gridFile, normalize=True)    
    i = tvtk.ImageData(spacing=grid3D.stepSize, origin=grid3D.origin, dimensions=grid3D.data.shape)
    i.point_data.scalars = numpy.ravel(grid3D.data.copy(),order='F')
    i.point_data.scalars.name = 'scalars'
    
    return i

def convert(gridFile):
    tvtkGrid = convertToTVTK(gridFile)
    base, ext = os.path.splitext(gridFile)
    w = tvtk.XMLImageDataWriter(input=tvtkGrid, file_name=base+".xml")
    w.write()
      
def usage():
    print """ Usage: """ +__file__ +""" input
    
    List of input files supported: 
    
    * AutoGrid
    * BRIX/DNS6
    * CCP4
    * CNS/XPLORE
    * Data Explorer(DX)
    * Delphi    
    * GRD
    * MRC
    * Rawiv
    * SPIDER
    * UHDB/GRID
    * AVS/FLD Binary
    
    Visit http://mgltools.scripps.edu/documentation/tutorial/volume-rendering/introduction
    for the links to these format descriptions""" 

if __name__ == '__main__':
    if len(sys.argv) < 2:
        print "Error: No input file\n"
        usage()
    else:
        convert(sys.argv[1])
