#$Id: importWizard.py 272 2016-04-21 21:56:49Z sarkiss $
import  wx
import  wx.wizard as wiz
import os
import urllib
import tarfile
from utils import rcFolder
pdbFolder = os.path.join(rcFolder,'PDB')
if not os.path.exists(pdbFolder):
    os.mkdir(pdbFolder)
import logging
logging.raiseExceptions = 0
from download import download

class RemotePDBPage(wiz.PyWizardPage):
    def __init__(self, parent):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        sizer = wx.BoxSizer(wx.VERTICAL)
        self.SetSizer(sizer)
        title = wx.StaticText(self, -1, "Import Molecule From Web:")
        sizer.Add(title, 0, wx.ALIGN_LEFT|wx.ALL, 5)
        sizer.Add(wx.StaticLine(self, -1), 0, wx.EXPAND|wx.ALL, 5)
        box = wx.StaticBox(self, -1, "PDB from RCSB.ORG")
        bsizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        PDBsizer = wx.BoxSizer(wx.HORIZONTAL)
        http = "http://www.rcsb.org/pdb/download/downloadFile.do?fileFormat=pdb&compression=NO&structureId="
        self.http = http
        PDBsizer.Add(wx.StaticText(self, -1, "PDB ID:"), 0, wx.ALL, 5)
        self.PDBIDTextCtrl = wx.TextCtrl(self, -1, '1crn', size=(50, -1))
        PDBsizer.Add(self.PDBIDTextCtrl, 0, wx.ALL, 5)
        bsizer.Add(PDBsizer, 1, wx.ALIGN_RIGHT)
        sizer.Add(bsizer, 0, wx.EXPAND)        
        
        box = wx.StaticBox(self, -1, "URL")
        URLsizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        self.URLTextCtrl = wx.TextCtrl(self, -1, "", size=(380, -1))
        URLsizer.Add(self.URLTextCtrl, 1, wx.ALL, 5)
        sizer.Add(URLsizer, 0, wx.EXPAND)        
        txt = """
Leave URL empty to retrieve molecule using PDB ID.
Otherwise, URL is used instead of PDB.
"""
        sizer.Add(wx.StaticText(self, -1, txt), 0, wx.ALIGN_BOTTOM)
        self.sizer = sizer
        
    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetPrev(self):
        return self.prev
    
    def Finish(self):
        dlg = wx.ProgressDialog("Download Progress",
                               "Please wait...",
                               parent=self,
                               style = wx.PD_CAN_ABORT
                                | wx.PD_APP_MODAL
                                | wx.PD_ELAPSED_TIME
                                )
        dlg.Update(0, "Please Wait...") 
        self.Parent.Parent.SetAllCursors(wx.StockCursor(wx.CURSOR_WAIT))
        pdbID = self.PDBIDTextCtrl.GetValue()
        URI = self.URLTextCtrl.GetValue()
        if URI:
            pdbID = URI.split("/")[-1][:-4]
        elif pdbID:
            pdbID = pdbID.lower()
            URI = self.http + pdbID
        try:
            fURL = urllib.urlopen(URI)
        except Exception, inst:
            dlg.Destroy()
            wx.MessageBox(URI, "Can't Open URL")
            return
        keepGoing = True
        count = 0
        try:
            tmpFileName = os.path.join(pdbFolder, pdbID+".pdb")
            tmpFile = open(tmpFileName,'w')
            while keepGoing:
                (keepGoing, skip) = dlg.UpdatePulse()
                b = fURL.read(20000)
                if b:
                    tmpFile.write(b)
                else:
                    tmpFile.close()
                    break
            if keepGoing:
                dlg.UpdatePulse("Reading Molecule...")
                dlg.Destroy()
                self.Parent.Parent.molNav.TryOpenMolecule(tmpFileName)
        except Exception, e:
            logging.error(str(e))
            dlg.Destroy()
            wx.MessageBox("Sorry there a problem with finishing this task\n"+str(e), "Can't Open URL "+ URI)
        self.Parent.Parent.SetAllCursors(wx.NullCursor) 
        self.Parent.Parent.navigator.SetSelection(0)
        
class FirstPage(wiz.PyWizardPage):
    def __init__(self, parent):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        sizer = wx.BoxSizer(wx.VERTICAL)
        self.SetSizer(sizer)
        title = wx.StaticText(self, -1, "Select Import Source:")
        sizer.Add(title, 0, wx.ALIGN_LEFT|wx.ALL, 5)
        sizer.Add(wx.StaticLine(self, -1), 0, wx.EXPAND|wx.ALL, 5)
        self.importList = ['Workspace Tarball  - Local File', 'Workspace Tarball  - Remote File',
                           'Molecule From Web - PDB, mmCIF, MOL2, PQR or PDBQT']
        if hasattr(self.Parent.Parent, 'openBabel'):
            self.importList.append("Chemical Table File - SDF")
        self.listBox = wx.ListBox(self, choices=self.importList, style=wx.LB_SINGLE)
        self.listBox.SetSelection(2)
        self.Bind(wx.EVT_LISTBOX, self.EvtListBox, self.listBox)
        
        sizer.Add(self.listBox, 1, wx.EXPAND)
        self.sizer = sizer

    def EvtListBox(self, event):
        selection = event.GetSelection()
        if selection == 2:
            self.next = self.pdbPage
        if selection == 1:
            self.next = self.tarPage

            
    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    # Classes derived from wxPyWizardPanel must override
    # GetNext and GetPrev, and may also override GetBitmap
    # as well as all those methods overridable by
    # wx.PyWindow.

    def GetNext(self):
        
        selection = self.listBox.GetSelections()[0]
        if selection == 0:
            dlg = wx.FileDialog(self, "Choose a tarball", os.getcwd(), "", 
                                "Tarball (*.tar.gz,)|*.tar.gz", wx.OPEN)
            if dlg.ShowModal() == wx.ID_OK:
                filename = dlg.GetPath() 
                self.Parent.Parent.SetAllCursors(wx.StockCursor(wx.CURSOR_WAIT))
                self.Parent.Parent.Update()                       
                tar = tarfile.open(filename)
                from enthought.preferences.api import get_default_preferences
                pref = get_default_preferences()
                tar.extractall(pref.get('AutoDock.workspace'))
                tar.close()                
                self.prev = 1
                self.Parent.Parent.SetAllCursors(wx.NullCursor) 
            else:
                self.next = None
            dlg.Destroy()
            self.listBox.SetSelection(1)
        elif selection == 3:
            self.next = None #this is needed to finish the wizard. See ImportWizard.Start below
            self.Parent.Parent.openBabel.Open()
            self.listBox.SetSelection(1) #this is needed since this function is called twice
        else:
            return self.next            
        
    def GetPrev(self):
        return self.prev

class RemoteURLPage(wiz.PyWizardPage):
    def __init__(self, parent):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        sizer = wx.BoxSizer(wx.VERTICAL)
        self.SetSizer(sizer)
        title = wx.StaticText(self, -1, "Enter the location (URL) of remote tarball:")
        sizer.Add(title, 0, wx.ALIGN_LEFT|wx.ALL, 5)
        sizer.Add(wx.StaticLine(self, -1), 0, wx.EXPAND|wx.ALL, 5)
        box = wx.StaticBox(self, -1, "")
        bsizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        URLsizer = wx.BoxSizer(wx.HORIZONTAL)
        #URLsizer.Add(wx.StaticText(self, -1, 'URL:'), 0, wx.ALL, 5)
        http = "http://pyrx.sf.net/sample.tar.gz"
        self.URLTextCtrl = wx.TextCtrl(self, -1, http)
        self.http = http
        URLsizer.Add(self.URLTextCtrl, 1, wx.EXPAND)         
        bsizer.Add(URLsizer, 1, wx.EXPAND)
        sizer.Add(bsizer, 0, wx.EXPAND)
        sizer.Add(wx.StaticText(self, -1, 
"""\nA demo tarball containing AutoDock 4 dataset can be found at:\n\n"""+http))

        self.sizer = sizer
        
    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetPrev(self):
        return self.prev

    def Finish(self):
        http = self.URLTextCtrl.GetValue()
        tmpFileName = os.path.join(pdbFolder, "_data.tar.gz")  
        try:
            download(http, tmpFileName)
        except Exception, inst:
            logging.error(str(inst))
            wx.MessageBox(http, "Can't Open URL")
            return
        self.Parent.Parent.SetAllCursors(wx.StockCursor(wx.CURSOR_WAIT))
        self.Parent.Parent.Update()       
        try:
            from enthought.preferences.api import get_default_preferences
            tar = tarfile.open(tmpFileName)
            pref = get_default_preferences()
            tar.extractall(pref.get('AutoDock.workspace'))
            tar.close()
            os.remove(tmpFileName)
            self.prev = 1
        except Exception, inst:
            logging.error(str(inst))
        self.Parent.Parent.SetAllCursors(wx.NullCursor) 
        self.Parent.Parent.navigator.SetSelection(1)

class ImportWizard:
    def __init__(self, parent):
        self.parent = parent
        
    def Start(self):        
        wizard = wiz.Wizard(self.parent, -1, "PyRx Import Wizard")
        page1 = FirstPage(wizard)
        page2 = RemoteURLPage(wizard)
        page3 = RemotePDBPage(wizard)
        page1.pdbPage = page3     
        page1.tarPage = page2
        self.page1 = page1
        wizard.FitToPage(page1)

        page1.SetNext(page3)
        page2.SetPrev(page1)
        page3.SetPrev(page1)
        
        wizard.GetPageAreaSizer().Add(page1)
        if wizard.RunWizard(page1):
            if page1.prev:
                self.parent.navigator.SetSelection(1)                
                self.parent.autodockNav.autodockTree.ligandTree.OnRefresh(None)
                self.parent.autodockNav.autodockTree.macromoleculeTree.OnRefresh(None)            
                wx.MessageBox("Import Completed Successfully", "Import Completed Successfully")
            elif page1.next == page3:
                page3.Finish()
            elif page1.next == page2:
                page2.Finish()
                self.parent.navigator.SetSelection(1)                
                self.parent.autodockNav.autodockTree.ligandTree.OnRefresh(None)
                self.parent.autodockNav.autodockTree.macromoleculeTree.OnRefresh(None)            
                wx.MessageBox("Import Completed Successfully", "Import Completed Successfully")
                
