#$Id: matplotlibCanvas.py 91 2011-02-07 23:01:27Z sarkiss $
import os
import wx
import wx.aui
import matplotlib as mpl
from matplotlib.backends.backend_wxagg import FigureCanvasWxAgg as Canvas
from matplotlib.backends.backend_wxagg import NavigationToolbar2Wx as Toolbar
from icons import chart_curvePNG
class Plot(wx.Panel):
    def __init__(self, parent, id = -1, dpi = None, **kwargs):
        wx.Panel.__init__(self, parent, id=id, **kwargs)
        self.figure = mpl.figure.Figure(dpi=dpi, figsize=(2,2))
        self.canvas = Canvas(self, -1, self.figure)
        self.toolbar = Toolbar(self.canvas)
        self.toolbar.Realize()

        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.toolbar, 0 , wx.LEFT | wx.EXPAND)
        sizer.Add(self.canvas,1,wx.EXPAND)
        self.SetSizer(sizer)

class PlotNotebook(wx.Panel):
    def __init__(self, parent, id = -1):
        wx.Panel.__init__(self, parent, id=id)
        self.nb = wx.aui.AuiNotebook(self, style=wx.aui.AUI_NB_TOP | 
                                       wx.aui.AUI_NB_TAB_SPLIT | 
                                       wx.aui.AUI_NB_TAB_MOVE | 
                                       wx.aui.AUI_NB_TAB_FIXED_WIDTH |
                                       wx.aui.AUI_NB_SCROLL_BUTTONS |
                                       wx.aui.AUI_NB_WINDOWLIST_BUTTON|
                                       wx.aui.AUI_NB_CLOSE_ON_ACTIVE_TAB)
        sizer = wx.BoxSizer()
        sizer.Add(self.nb, 1, wx.EXPAND)
        self.SetSizer(sizer)
        self.frame = parent
        self.frame.view.AddPage(self,'2D Plots', bitmap=chart_curvePNG)
        page = self.add("Figure")
        page.figure.add_subplot(111)
        self.firstPlot = True
        
    def add(self, name="plot"):
       page = Plot(self.nb)
       self.nb.AddPage(page, name, select=True)
       return page
