#$Id: utils.py 243 2015-01-25 00:56:19Z sarkiss $
"""util.py currently contains which() function used to show the full path of autodock.
"""
import os, sys, shutil
from about import appName

def which (filename):
    """Source http://mail.python.org/pipermail/python-list/2002-August/157829.html"""
    if os.access(filename, os.X_OK):
            return filename    
    if not os.environ.has_key('PATH') or os.environ['PATH'] == '':
        p = os.defpath
    else:
        p = os.environ['PATH']

    pathlist = p.split (os.pathsep)
    pathlist.append(os.path.split(sys.executable)[0])
    
    for path in pathlist:
        f = os.path.join(path, filename)
        if os.access(f, os.X_OK):
            return f
    return None

def cpuCount():
    '''
    Returns the number of CPUs in the system
    '''
    num = 1
    if sys.platform == 'win32':
        try:
            num = int(os.environ['NUMBER_OF_PROCESSORS'])
        except (ValueError, KeyError):
            pass
    elif sys.platform == 'darwin':
        try:
            num = int(os.popen('sysctl -n hw.ncpu').read())
        except ValueError:
            pass
    else:
        try:
            num = os.sysconf('SC_NPROCESSORS_ONLN')
        except (ValueError, OSError, AttributeError):
            pass        
    return num       

from misc import rcFolder
if not os.path.isdir(rcFolder):
    try:
        os.mkdir(rcFolder)
    except: #in case we can't mkdir in user.home
        from tempfile import gettempdir
        rcFolder = gettempdir() + os.path.sep + '.' + appName
        if not os.path.isdir(rcFolder):
            os.mkdir(rcFolder)
        
rcFile = os.path.join(rcFolder, 'preferences.ini')

def createPreferences():
    global rcFile, rcFolder
    if not os.path.exists(rcFile):
        try:
            shutil.copy(os.path.join(os.path.split(__file__)[0], 'preferences.ini'), rcFile)
        except Exception, inst:
            print inst
            print "Please make sure that you have a write permission for "+rcFolder
            import tempfile
            rcFolder =tempfile.mkdtemp()
            rcFile = os.path.join(rcFolder, 'preferences.ini')
            shutil.copy(os.path.join(os.path.split(__file__)[0], 'preferences.ini'), rcFile) 
        txt = open(rcFile).read()
        txt = txt.replace("workspace = .", "workspace = "+rcFolder)
        if cpuCount()-1 > 0:
            txt = txt.replace("cpu_num = 1", "cpu_num = "+str(cpuCount()-1))
        pyrx_path = os.path.split(sys.executable)[0]    
        if sys.platform == 'win32':
            vina = os.path.join(pyrx_path, 'vina.exe')
            autodock = os.path.join(pyrx_path, 'autodock4.exe')
            autogrid = os.path.join(pyrx_path, 'autogrid4.exe')
        elif sys.platform == 'darwin':
            #./Python.framework/Versions/2.6/lib/python2.6/site-packages
            pyrx_home = os.path.split(os.path.split(os.path.split(os.path.split(os.path.split(os.path.split(os.path.split(os.path.split(__file__)[0])[0])[0])[0])[0])[0])[0])[0]
            vina = os.path.join(pyrx_home, 'bin', 'vina')
            autodock = os.path.join(pyrx_home, 'bin', 'autodock4')
            autogrid = os.path.join(pyrx_home, 'bin', 'autogrid4')
        elif "linux" in sys.platform:
            vina = os.path.join(pyrx_path, 'vina')
            autodock = os.path.join(pyrx_path, 'autodock4')
            autogrid = os.path.join(pyrx_path, 'autogrid4')
        txt = txt.replace("vina = vina\n", "vina = "+vina+"\n")
        txt = txt.replace("autodock = autodock4\n", "autodock = "+autodock+"\n")
        txt = txt.replace("autogrid = autogrid4\n", "autogrid = "+autogrid+"\n")
        open(rcFile,'w').write(txt)

createPreferences()

def RemoveDirs(path):
    """source http://docs.python.org/lib/os-file-dir.html
    Delete everything reachable from the directory named in 'top',
    assuming there are no symbolic links.
    CAUTION:  This is dangerous!  For example, if top == '/', it
    could delete all your disk files."""
    for root, dirs, files in os.walk(path, topdown=False):
        for name in files:
            try:
                os.remove(os.path.join(root, name))
            except OSError:
                pass
        for name in dirs:
            try:
                os.rmdir(os.path.join(root, name))
            except OSError:
                pass   
    try:
        os.removedirs(path) # added to remove path itself
        os.rmdir(path)
    except OSError:
        pass