#$Id: vtkAdaptor.py 142 2013-07-08 22:53:51Z sarkiss $
""" This modules contains  vtkAdaptor class that provides 
functions required to interface PyRx with PMV. We are extending  
vtkAdaptor from ePMV/epmvAdaptor and customize it for VTK. 

"""
from ePMV.epmvAdaptor import epmvAdaptor, loadMoleculeInHost
from Pmv.moleculeViewer import MoleculeViewer
from Pmv.moleculeViewer import DeleteGeomsEvent, AddGeomsEvent, EditGeomsEvent
from Pmv.moleculeViewer import DeleteAtomsEvent, EditAtomsEvent
#Pmv Color Palette
from Pmv.pmvPalettes import AtomElements
from Pmv.pmvPalettes import DavidGoodsell, DavidGoodsellSortedKeys
from Pmv.pmvPalettes import RasmolAmino, RasmolAminoSortedKeys
from Pmv.pmvPalettes import Shapely
from Pmv.pmvPalettes import SecondaryStructureType
from Pmv.pmvPalettes import DnaElements
import vtk

class vtkAdaptor(epmvAdaptor):
    """This is a class similar to ePMV/epmvAdaptor
    We'll use minimal features required for secondaryStructureCommands.
    """ 
    def __init__(self):
        "Constructor for epmvAdaptor"
        self.mv = MoleculeViewer(logMode = 'overwrite', customizer='./.empty', master=None,title='pmv', withShell= 0,verbose=False, gui = False)
        self.mv.browseCommands('fileCommands', package="Pmv", topCommand=0)
        self.mv.browseCommands("secondaryStructureCommands", package="Pmv", topCommand=0)
        self.mv.browseCommands('bondsCommands',package='Pmv', topCommand=0)
        self.mv.browseCommands('colorCommands',package='Pmv', topCommand=0)
        self.mv.browseCommands('hbondCommands', commands=['buildHBonds'],  package="Pmv", topCommand=0)
        self.setupMV()
        self.useLog = False
        self.colorProxyObject = False      
        self.duplicatemol = False  
        self.center_mol = False
        self.useModeller = False
        self.doCloud = False
        self.doCamera = False        
        self.doLight = False   
        self.use_progressBar = False
        self.helper = Helper()
        self.host = 'pyrx'        
        self.meshes = {}
        if not hasattr(self.mv,'molDispl') : self.mv.molDispl={}
        if not hasattr(self.mv,'MolSelection') : self.mv.MolSelection={}
        if not hasattr(self.mv,'selections') : self.mv.selections={}
        if not hasattr(self.mv,'iMolData') :self.mv.iMolData={}        
        
    def setupMV(self):
        #define the listener    
        self.mv.addCommand(loadMoleculeInHost(self),'_loadMol',None)        
        self.mv.registerListener(DeleteGeomsEvent, self.updateGeom)
        self.mv.registerListener(AddGeomsEvent, self.updateGeom)
        self.mv.registerListener(EditGeomsEvent, self.updateGeom)
        self.mv.registerListener(DeleteAtomsEvent, self.updateModel)
        self.mv.undoableDelete__ = True
        
    def _getCurrentScene(self):
        pass
    
    def _newEmpty(self, name, **kw):
        return vtk.vtkAssembly()
    
    def _addObjectToScene(self, sc,master, **kw):
        pass
    
    def _getObjectName(self, o):
        return  o.GetClassName()

    def  _toggleDisplay(self, obj,display):
        pass

    def _getObject(self, name):
        pass
    
    def _createsNmesh(self, name,vertices,vnormals,faces,color=None, **kw):
        polyData = vtk.vtkPolyData()
        points = vtk.vtkPoints()
        polys = vtk.vtkCellArray()
        points.SetDataTypeToFloat()
        points.SetNumberOfPoints(len(vertices))
        for i, vertex in enumerate(vertices):
            points.SetPoint(i, vertex)

        for i, face in enumerate(faces):
             polys.InsertNextCell(4)
             polys.InsertCellPoint(face[0])
             polys.InsertCellPoint(face[1])
             polys.InsertCellPoint(face[3])
             polys.InsertCellPoint(face[2])

        polyData.SetPoints(points)
        polyData.SetStrips(polys)
        names = name.split("_")
        if len(names) > 3:
            molName = "_".join(names[:-2])
        else:
            molName = names[0]
        mol = self.mv.getMolFromName(molName)
        chain = mol.childByName[names[-2]]
        assembly = chain.residues.atoms[0].assembly
        if not hasattr(assembly, 'ribbons_assembly'):
             assembly.ribbons_assembly = vtk.vtkAssembly()
             assembly.AddPart(assembly.ribbons_assembly)

        normals = vtk.vtkPolyDataNormals()
        normals.SetInput(polyData)
        ssMapper = vtk.vtkPolyDataMapper()
        ssMapper.SetInput(normals.GetOutput())
        stripActor = vtk.vtkLODActor()
        stripActor.SetMapper(ssMapper)
        stripActor.GetProperty().SetRepresentationToSurface()
        stripActor.name = name
        for key in SecondaryStructureType.keys():
            if key in name:
                stripActor.GetProperty().SetColor(SecondaryStructureType[key])
                break    
        assembly.ribbons_assembly.AddPart(stripActor)    
        self.meshes[name] = stripActor
        polyData.name = name
        return polyData, stripActor
        
        
class Helper():
    def addMaterial(self,name,col):
        pass
    
    def getName(self, o):
        if hasattr(o, 'name'):
            return o.name
        else:
            return 'foo'
    
    def colorMaterial(self,mat,color):
        pass    

    def getMesh(self, mesh):
        return mesh
    
    def updateMesh(self, mesh, vertices,  faces):
        #TODO: implement this

        pass
        
    